/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    private static RegistryAccess REGISTRY_ACCESS = null;
    private static final Field REGISTRY_FIELD = ObfuscationReflectionHelper.findField(Holder.Reference.class, (String)"f_205748_");
    private static final Field KEY_FIELD = ObfuscationReflectionHelper.findField(Holder.Reference.class, (String)"f_205751_");
    private static final Method BIND_TAGS = ObfuscationReflectionHelper.findMethod(Holder.Reference.class, (String)"m_205769_", (Class[])new Class[]{Collection.class});

    @Nullable
    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> registry) {
        return CSMath.getIfNotNull(RegistryHelper.getRegistryAccess(), access -> access.m_175515_(registry), null);
    }

    @Nullable
    public static RegistryAccess getRegistryAccess() {
        return REGISTRY_ACCESS;
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> mapForgeRegistryTagList(IForgeRegistry<T> registry, NegatableList<Either<TagKey<T>, T>> eitherList) {
        ArrayList list = new ArrayList();
        for (Either<TagKey<T>, T> either : eitherList.requirements()) {
            either.ifLeft(tagKey -> list.addAll(registry.tags().getTag(tagKey).stream().toList()));
            either.ifRight(object -> list.add(object));
        }
        for (Either<TagKey<T>, T> either : eitherList.exclusions()) {
            either.ifLeft(tagKey -> list.removeAll(registry.tags().getTag(tagKey).stream().toList()));
            either.ifRight(object -> list.remove(object));
        }
        return list;
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> mapForgeRegistryTagList(IForgeRegistry<T> registry, List<Either<TagKey<T>, T>> eitherList) {
        return RegistryHelper.mapForgeRegistryTagList(registry, new NegatableList<Either<TagKey<T>, T>>(eitherList));
    }

    public static <T> List<OptionalHolder<T>> mapVanillaRegistryTagList(ResourceKey<Registry<T>> registry, NegatableList<Either<TagKey<T>, OptionalHolder<T>>> eitherList, @Nullable RegistryAccess registryAccess) {
        Registry reg = registryAccess != null ? registryAccess.m_175515_(registry) : RegistryHelper.getRegistry(registry);
        ArrayList list = new ArrayList();
        if (reg == null) {
            return list;
        }
        for (Either<TagKey<T>, OptionalHolder<T>> either : eitherList.requirements()) {
            either.ifLeft(tagKey -> {
                Optional tag = reg.m_203431_(tagKey);
                tag.ifPresent(tag1 -> list.addAll(tag1.m_203614_().map(OptionalHolder::ofHolder).toList()));
            });
            either.ifRight(list::add);
        }
        for (Either<TagKey<T>, OptionalHolder<T>> either : eitherList.exclusions()) {
            either.ifLeft(tagKey -> {
                Optional tag = reg.m_203431_(tagKey);
                tag.ifPresent(tag1 -> list.removeAll(tag1.m_203614_().map(OptionalHolder::ofHolder).toList()));
            });
            either.ifRight(list::remove);
        }
        return list;
    }

    public static <T> List<OptionalHolder<T>> mapVanillaRegistryTagList(ResourceKey<Registry<T>> registry, List<Either<TagKey<T>, OptionalHolder<T>>> eitherList, @Nullable RegistryAccess registryAccess) {
        return RegistryHelper.mapVanillaRegistryTagList(registry, new NegatableList<Either<TagKey<T>, OptionalHolder<T>>>(eitherList), registryAccess);
    }

    public static <T> Optional<T> getVanillaRegistryValue(ResourceKey<Registry<T>> registry, ResourceLocation id) {
        try {
            return Optional.ofNullable(RegistryHelper.getRegistry(registry)).map(reg -> reg.m_7745_(id));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<Holder<T>> getHolder(T object, ResourceKey<Registry<T>> registry, RegistryAccess registryAccess) {
        Registry reg = registryAccess.m_175515_(registry);
        return reg.m_203300_(reg.m_7447_(object));
    }

    @Nullable
    public static ResourceLocation getKey(Holder<?> holder) {
        return holder.m_203543_().map(ResourceKey::m_135782_).orElse(null);
    }

    public static <T> Holder.Reference<T> modifyHolder(Holder.Reference<T> original, T value) {
        try {
            Registry owner = (Registry)REGISTRY_FIELD.get(original);
            Holder.Reference newHolder = Holder.Reference.m_205763_((Registry)owner, value);
            KEY_FIELD.set(newHolder, original.m_203543_().orElse(null));
            BIND_TAGS.invoke((Object)newHolder, original.m_203616_().toList());
            return newHolder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
    }

    static {
        REGISTRY_FIELD.setAccessible(true);
        KEY_FIELD.setAccessible(true);
        BIND_TAGS.setAccessible(true);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class GetAccessClient {
        @SubscribeEvent
        public static void onClientLoading(ClientPlayerNetworkEvent.LoggedInEvent event) {
            if (!Minecraft.m_91087_().m_91091_()) {
                REGISTRY_ACCESS = event.getPlayer().f_108617_.m_105152_();
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class GetAccessServer {
        @SubscribeEvent
        public static void onServerLoading(ServerConfigsLoadedEvent event) {
            REGISTRY_ACCESS = event.getServer().m_206579_();
        }
    }
}

