/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.ConfiguredBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Triplet;

public class BlockTempModifier
extends TempModifier {
    protected static final double LOG_FACTOR = 0.52;
    Map<ChunkPos, ChunkAccess> chunks = new HashMap<ChunkPos, ChunkAccess>(9);
    Map<BlockTemp, Double> blockTempTotals = new HashMap<BlockTemp, Double>(16);
    Map<BlockPos, BlockState> stateCache = new HashMap<BlockPos, BlockState>(3000);
    List<Triplet<BlockPos, BlockTemp, Double>> triggers = new ArrayList<Triplet<BlockPos, BlockTemp, Double>>(16);

    public BlockTempModifier() {
    }

    public BlockTempModifier(int range) {
        if (range > 0) {
            this.getNBT().m_128405_("RangeOverride", range);
        }
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        this.blockTempTotals.clear();
        this.stateCache.clear();
        this.triggers.clear();
        Level level = entity.m_9236_();
        int range = this.getNBT().m_128425_("RangeOverride", 3) ? this.getNBT().m_128451_("RangeOverride") : ConfigSettings.BLOCK_RANGE.get().intValue();
        BlockPos blockPos = entity.m_20183_();
        int entX = blockPos.m_123341_();
        int entY = blockPos.m_123342_();
        int entZ = blockPos.m_123343_();
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        boolean shouldTickAdvancements = this.getTicksExisted() % 20 == 0;
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                ChunkPos chunkPos = new ChunkPos(entX + x >> 4, entZ + z >> 4);
                ChunkAccess chunk = this.chunks.get(chunkPos);
                if (chunk == null) {
                    chunk = WorldHelper.getChunk((LevelAccessor)level, chunkPos);
                    this.chunks.put(chunkPos, chunk);
                }
                if (chunk == null) continue;
                block2: for (int y = -range; y < range; ++y) {
                    Collection<BlockTemp> blockTemps;
                    blockpos.m_122178_(entX + x, entY + y, entZ + z);
                    BlockState state = this.stateCache.get(blockpos);
                    if (state == null) {
                        LevelChunkSection section = WorldHelper.getChunkSection(chunk, blockpos.m_123342_());
                        state = section.m_62982_(blockpos.m_123341_() & 0xF, blockpos.m_123342_() & 0xF, blockpos.m_123343_() & 0xF);
                        this.stateCache.put(blockpos.m_7949_(), state);
                    }
                    if (state.m_60795_() || (blockTemps = BlockTempRegistry.getBlockTempsFor(state)).isEmpty() || blockTemps.size() == 1 && blockTemps.contains(BlockTempRegistry.DEFAULT_BLOCK_TEMP) || !this.areAnyBlockTempsInRange(blockTemps)) continue;
                    Vec3 pos = Vec3.m_82512_((Vec3i)blockpos);
                    Vec3 playerClosest = WorldHelper.getClosestPointOnEntity(entity, pos);
                    int[] blocks = new int[1];
                    Vec3 ray = pos.m_82546_(playerClosest);
                    Direction direction = Direction.m_122366_((double)ray.f_82479_, (double)ray.f_82480_, (double)ray.f_82481_);
                    WorldHelper.forBlocksInRay(playerClosest, pos, level, chunk, this.stateCache, (rayState, bpos) -> {
                        if (!bpos.equals((Object)blockpos) && WorldHelper.isSpreadBlocked((LevelAccessor)level, rayState, bpos, direction, direction)) {
                            blocks[0] = blocks[0] + 1;
                        }
                    }, 3);
                    double distance = CSMath.getDistance(playerClosest, pos);
                    for (BlockTemp blockTemp : blockTemps) {
                        if (!blockTemp.isValid(level, (BlockPos)blockpos, state)) continue;
                        double temperature = blockTemp.getTemperature(level, entity, state, (BlockPos)blockpos, distance);
                        double tempToAdd = blockTemp.fade() ? CSMath.blend(temperature, 0.0, distance, 0.5, blockTemp.range()) : temperature;
                        double blockTempTotal = this.blockTempTotals.getOrDefault(blockTemp, 0.0);
                        double blockGroupTotal = this.getGroupTotal(blockTemp);
                        double blockGroupDelta = blockGroupTotal - blockTempTotal;
                        if (blockTemp.logarithmic()) {
                            newTotal = Math.pow(Math.pow(blockTempTotal, 1.923076923076923) + tempToAdd, 0.52);
                            double delta = newTotal - blockTempTotal;
                            this.blockTempTotals.put(blockTemp, CSMath.clamp(blockTempTotal + (delta /= (double)(blocks[0] + 1)), blockTemp.minEffect() + blockGroupDelta, blockTemp.maxEffect() - blockGroupDelta));
                        } else {
                            newTotal = blockTempTotal + (tempToAdd /= (double)(blocks[0] + 1));
                            this.blockTempTotals.put(blockTemp, CSMath.clamp(newTotal, blockTemp.minEffect() + blockGroupDelta, blockTemp.maxEffect() - blockGroupDelta));
                        }
                        if (!shouldTickAdvancements) continue block2;
                        this.triggers.add((Triplet<BlockPos, BlockTemp, Double>)new Triplet((Object)blockpos, (Object)blockTemp, (Object)distance));
                        continue block2;
                    }
                }
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (shouldTickAdvancements) {
                for (Triplet<BlockPos, BlockTemp, Double> trigger : this.triggers) {
                    ModAdvancementTriggers.BLOCK_AFFECTS_TEMP.trigger(player, (BlockPos)trigger.getA(), (Double)trigger.getC(), this.blockTempTotals.get(trigger.getB()));
                }
            }
        }
        while (this.chunks.size() >= 16) {
            this.chunks.remove(this.chunks.keySet().iterator().next());
        }
        return temp -> {
            for (Map.Entry<BlockTemp, Double> entry : this.blockTempTotals.entrySet()) {
                BlockTemp blockTemp = entry.getKey();
                double min = blockTemp.minTemperature();
                double max = blockTemp.maxTemperature();
                if (!CSMath.betweenInclusive(temp, min, max)) continue;
                double effectValue = entry.getValue();
                temp = CSMath.clamp(temp + effectValue, min, max);
            }
            return temp;
        };
    }

    private boolean areAnyBlockTempsInRange(Collection<BlockTemp> blockTemps) {
        for (BlockTemp blockTemp : blockTemps) {
            if (!this.blockTempTotals.containsKey(blockTemp)) {
                return true;
            }
            double effectTotal = this.getGroupTotal(blockTemp);
            if (!CSMath.betweenInclusive(effectTotal, blockTemp.minEffect(), blockTemp.maxEffect())) continue;
            return true;
        }
        return false;
    }

    private double getGroupTotal(BlockTemp blockTemp) {
        TagKey group;
        if (blockTemp instanceof ConfiguredBlockTemp) {
            ConfiguredBlockTemp config = (ConfiguredBlockTemp)blockTemp;
            v0 = config.getData().effectGroup().orElse(null);
        } else {
            v0 = group = null;
        }
        if (group == null) {
            return this.blockTempTotals.getOrDefault(blockTemp, 0.0);
        }
        return this.blockTempTotals.keySet().stream().filter(bt -> {
            ConfiguredBlockTemp config;
            return bt instanceof ConfiguredBlockTemp && (config = (ConfiguredBlockTemp)bt).isInGroup((TagKey<BlockTempData>)group);
        }).map(bt -> (ConfiguredBlockTemp)bt).mapToDouble(b -> this.blockTempTotals.getOrDefault(b, 0.0)).sum();
    }
}

