/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier.compat;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import weather2.ServerTickHandler;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;

public class StormTempModifier
extends TempModifier {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double stormTemp;
        if (entity.m_9236_().m_5776_()) return temp -> temp;
        WeatherManagerServer weatherManager = ServerTickHandler.getWeatherManagerFor((ResourceKey)entity.m_9236_().m_46472_());
        float windSpeed = weatherManager.getWindManager().getWindSpeedPositional(entity.m_20183_());
        WeatherObject weather = (WeatherObject)CompatManager.Weather2.getClosestStorm(entity.m_9236_(), entity.m_20183_());
        if (weather instanceof WeatherObjectParticleStorm) {
            WeatherObjectParticleStorm storm = (WeatherObjectParticleStorm)weather;
            double distance = storm.posGround.m_82554_(entity.m_20182_());
            if (storm.type == WeatherObjectParticleStorm.StormType.SANDSTORM) {
                stormTemp = -CSMath.blend(0.0, (double)(storm.getIntensity() / 3.0f), distance, (double)storm.getSize(), 0.0);
                return temp -> temp - stormTemp - (double)(windSpeed / 5.0f);
            }
            if (storm.type == WeatherObjectParticleStorm.StormType.SNOWSTORM) {
                stormTemp = CSMath.blend(0.0, (double)storm.getIntensity(), distance, (double)storm.getSize(), 0.0);
                return temp -> temp - stormTemp - (double)(windSpeed / 5.0f);
            }
            stormTemp = 0.0;
            return temp -> temp - stormTemp - (double)(windSpeed / 5.0f);
        }
        if (weather instanceof StormObject) {
            StormObject storm = (StormObject)weather;
            if (storm.levelCurIntensityStage >= StormObject.STATE_FORMING) {
                double distance = storm.posGround.m_82554_(entity.m_20182_());
                stormTemp = CSMath.blend(0.0, (double)(storm.strength / 300.0f), distance, (double)storm.getSize(), 0.0);
                return temp -> temp - stormTemp - (double)(windSpeed / 5.0f);
            }
        }
        stormTemp = 0.0;
        return temp -> temp - stormTemp - (double)(windSpeed / 5.0f);
    }
}

