/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.ClientConfigAskMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector2i;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DrawConfigButton {
    public static boolean EDIT_MODE = false;

    @SubscribeEvent
    public static void eventHandler(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof OptionsScreen && ConfigSettings.SHOW_CONFIG_BUTTON.get().booleanValue()) {
            DynamicHolder<Vector2i> buttonPos = ConfigSettings.CONFIG_BUTTON_POS;
            AtomicInteger xOffset = new AtomicInteger(((Vector2i)buttonPos.get()).x());
            AtomicInteger yOffset = new AtomicInteger(((Vector2i)buttonPos.get()).y());
            int buttonX = event.getScreen().f_96543_ / 2 - 183;
            int buttonY = event.getScreen().f_96544_ / 6 + 110;
            int screenWidth = event.getScreen().f_96543_;
            int screenHeight = event.getScreen().f_96544_;
            if (xOffset.get() + buttonX < -1 || yOffset.get() + buttonY < -1) {
                xOffset.set(0);
                yOffset.set(0);
                ConfigSettings.CONFIG_BUTTON_POS.set(new Vector2i(0, 0));
            }
            ImageButton mainButton = new ImageButton(buttonX + xOffset.get(), buttonY + yOffset.get(), 24, 24, 40, 40, 24, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                ConfigScreen.CURRENT_PAGE = 0;
                if (Minecraft.m_91087_().f_91074_ != null) {
                    ColdSweatPacketHandler.INSTANCE.sendToServer((Object)new ClientConfigAskMessage(Minecraft.m_91087_().f_91074_.m_20148_()));
                }
            });
            if (Minecraft.m_91087_().f_91073_ == null) {
                mainButton.f_93623_ = false;
                mainButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.cold_sweat.config.must_be_in_game").m_130940_(ChatFormatting.RED)));
            }
            event.addListener((GuiEventListener)mainButton);
            if (EDIT_MODE) {
                int buttonStartX = event.getScreen().f_96543_ / 2 - 183;
                int buttonStartY = event.getScreen().f_96544_ / 6 + 110;
                Runnable saveAndClamp = () -> {
                    xOffset.set(CSMath.clamp(xOffset.get(), -buttonStartX, screenWidth - mainButton.m_5711_() - buttonStartX));
                    yOffset.set(CSMath.clamp(yOffset.get(), -buttonStartY, screenHeight - mainButton.m_93694_() - buttonStartY));
                    mainButton.m_264152_(buttonStartX + xOffset.get(), buttonStartY + yOffset.get());
                    ConfigSettings.CONFIG_BUTTON_POS.set(new Vector2i(xOffset.get(), yOffset.get()));
                };
                AtomicReference<Object> doneButtonAtomic = new AtomicReference<Object>(null);
                event.getScreen().m_6702_().forEach(child -> {
                    if (child instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)child;
                        boolean isDoneButton = button.m_6035_().getString().equals(CommonComponents.f_130655_.getString());
                        if (!isDoneButton) {
                            button.f_93623_ = false;
                        } else {
                            doneButtonAtomic.set(button);
                            button.m_93674_(button.m_5711_() - 72);
                        }
                    }
                    if (child instanceof AbstractSliderButton) {
                        AbstractSliderButton slider = (AbstractSliderButton)child;
                        slider.f_93623_ = false;
                    }
                });
                if (doneButtonAtomic.get() == null) {
                    return;
                }
                AbstractButton doneButton = doneButtonAtomic.get();
                ImageButton leftButton = new ImageButton(doneButton.m_252754_() + doneButton.m_5711_() + 2, doneButton.m_252907_(), 14, 20, 0, 0, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    xOffset.set(xOffset.get() - ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)leftButton);
                ImageButton upButton = new ImageButton(leftButton.m_252754_() + leftButton.m_5711_(), leftButton.m_252907_(), 20, 10, 14, 0, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    yOffset.set(yOffset.get() - ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)upButton);
                ImageButton downButton = new ImageButton(upButton.m_252754_(), upButton.m_252907_() + upButton.m_93694_(), 20, 10, 14, 10, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    yOffset.set(yOffset.get() + ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)downButton);
                ImageButton rightButton = new ImageButton(upButton.m_252754_() + upButton.m_5711_(), upButton.m_252907_(), 14, 20, 34, 0, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    xOffset.set(xOffset.get() + ConfigScreen.SHIFT_AMOUNT.get());
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)rightButton);
                ImageButton resetButton = new ImageButton(rightButton.m_252754_() + rightButton.m_5711_() + 2, rightButton.m_252907_(), 20, 20, 48, 0, 20, new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png"), button -> {
                    xOffset.set(0);
                    yOffset.set(0);
                    saveAndClamp.run();
                });
                event.addListener((GuiEventListener)resetButton);
                TaskScheduler.scheduleClient(() -> {
                    EDIT_MODE = false;
                }, 1);
            }
        }
    }
}

