/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.client.event.RegisterModels;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ChameleonArmorItem
extends ArmorItem {
    public ChameleonArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> playerModel) {
                RegisterModels.checkForInitModels();
                if (entityLiving instanceof Player) {
                    return Client.getPlayerArmorModel();
                }
                return Client.getRealArmorModel(entityLiving, itemStack, armorSlot);
            }
        });
    }

    public static final class Client {
        public static <A extends HumanoidModel<?>> A getPlayerArmorModel() {
            return (A)((Object)RegisterModels.EMPTY_ARMOR_MODEL);
        }

        public static HumanoidModel<?> getRealArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot) {
            RegisterModels.checkForInitModels();
            return switch (armorSlot) {
                case EquipmentSlot.HEAD -> RegisterModels.CHAMELEON_HELMET_MODEL;
                case EquipmentSlot.CHEST -> RegisterModels.CHAMELEON_CHESTPLATE_MODEL;
                case EquipmentSlot.LEGS -> RegisterModels.CHAMELEON_LEGGINGS_MODEL;
                case EquipmentSlot.FEET -> RegisterModels.CHAMELEON_BOOTS_MODEL;
                default -> RegisterModels.EMPTY_ARMOR_MODEL;
            };
        }
    }
}

