/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.io.Files;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.config.spec.CSConfigSpec;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.loading.FMLPaths;

public class ModUpdater {
    public static void updateEntity(LivingEntity entity) {
        String entityVersion = entity.getPersistentData().m_128461_("cs:version");
        if (ModUpdater.compareVersions(entityVersion, "2.3-b03a") < 0) {
            EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.getModifiers().forEach((trait, list) -> list.removeIf(mod -> mod.getClass() == InventoryItemsTempModifier.class)));
        }
        entity.getPersistentData().m_128359_("cs:version", ColdSweat.getVersion());
    }

    public static void updateConfigs() {
        if (!MainSettingsConfig.AUTO_UPDATE.get().booleanValue()) {
            return;
        }
        String version = ColdSweat.getVersion();
        String configVersion = MainSettingsConfig.VERSION.get();
        if (ModUpdater.isBehind(configVersion, "2.3-b05b")) {
            ColdSweat.LOGGER.error("Cancelling config auto-updater. Version {} is older than minimum supported version: 2.3-b05b", (Object)configVersion);
            return;
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b02a")) {
            ArrayList itemInsulations = new ArrayList(ItemSettingsConfig.INSULATION_ITEMS.get());
            for (List entry : itemInsulations) {
                if (!entry.contains("adaptive")) {
                    CSMath.setOrAppend(entry, 3, "static");
                }
                CSMath.setOrAppend(entry, 4, "");
                CSMath.setOrAppend(entry, 5, true);
            }
            ItemSettingsConfig.INSULATION_ITEMS.set(itemInsulations);
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_scale_helmet", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_scale_chestplate", Integer.valueOf(12), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_scale_leggings", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_scale_boots", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive", "", Boolean.valueOf(true)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, List.of("cold_sweat:chameleon_scale_helmet", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive"));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, List.of("cold_sweat:chameleon_scale_chestplate", Integer.valueOf(12), Double.valueOf(0.0085), "adaptive"));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, List.of("cold_sweat:chameleon_scale_leggings", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive"));
            ModUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, List.of("cold_sweat:chameleon_scale_boots", Integer.valueOf(8), Double.valueOf(0.0085), "adaptive"));
            ArrayList whitelist = new ArrayList(WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.get());
            whitelist.remove("cold_sweat:hearth_bottom");
            WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.set(whitelist);
            if (CompatManager.isTwilightForestLoaded()) {
                ModUpdater.addConfigSetting(WorldSettingsConfig.DIMENSION_TEMP_OFFSETS, List.of("twilightforest:twilight_forest_type", Double.valueOf(0.2)));
            }
            if (CompatManager.isAetherLoaded()) {
                ModUpdater.addConfigSetting(WorldSettingsConfig.DIMENSION_TEMP_OFFSETS, List.of("aether:the_aether", Double.valueOf(0.7)));
            }
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b02b")) {
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:lava", Double.valueOf(0.25), Integer.valueOf(7), "mc", Integer.valueOf(4), "", "", Double.valueOf(21.5)));
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b02c")) {
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:lava");
            ModUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:lava", Double.valueOf(0.25), Integer.valueOf(7), "mc", Integer.valueOf(4), "", "", Double.valueOf(21.5), Boolean.valueOf(true)));
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b03a")) {
            ModUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "cold_sweat:soul_stalk");
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b04a")) {
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "minecraft:leather_helmet");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "minecraft:leather_chestplate");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "minecraft:leather_leggings");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "minecraft:leather_boots");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:hoglin_headpiece");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:hoglin_tunic");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:hoglin_trousers");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:hoglin_hooves");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:goat_fur_cap");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:goat_fur_parka");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:goat_fur_pants");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:goat_fur_boots");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:chameleon_scale_helmet");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:chameleon_scale_chestplate");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:chameleon_scale_leggings");
            ModUpdater.removeConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:chameleon_scale_boots");
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "minecraft:leather_helmet", list -> {
                list.clear();
                list.addAll(List.of("minecraft:leather_helmet", Integer.valueOf(5), Integer.valueOf(5)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "minecraft:leather_chestplate", list -> {
                list.clear();
                list.addAll(List.of("minecraft:leather_chestplate", Integer.valueOf(7), Integer.valueOf(7)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "minecraft:leather_leggings", list -> {
                list.clear();
                list.addAll(List.of("minecraft:leather_leggings", Integer.valueOf(6), Integer.valueOf(6)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "minecraft:leather_boots", list -> {
                list.clear();
                list.addAll(List.of("minecraft:leather_boots", Integer.valueOf(5), Integer.valueOf(5)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:hoglin_headpiece", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:hoglin_headpiece", Integer.valueOf(0), Integer.valueOf(10)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:hoglin_tunic", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:hoglin_tunic", Integer.valueOf(0), Integer.valueOf(14)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:hoglin_trousers", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:hoglin_trousers", Integer.valueOf(0), Integer.valueOf(12)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:hoglin_hooves", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:hoglin_hooves", Integer.valueOf(0), Integer.valueOf(10)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:goat_fur_cap", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:goat_fur_cap", Integer.valueOf(10), Integer.valueOf(0)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:goat_fur_parka", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:goat_fur_parka", Integer.valueOf(14), Integer.valueOf(0)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:goat_fur_pants", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:goat_fur_pants", Integer.valueOf(12), Integer.valueOf(0)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:goat_fur_boots", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:goat_fur_boots", Integer.valueOf(10), Integer.valueOf(0)));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:chameleon_scale_helmet", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:chameleon_scale_helmet", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive"));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:chameleon_scale_chestplate", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:chameleon_scale_chestplate", Integer.valueOf(14), Double.valueOf(0.0085), "adaptive"));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:chameleon_scale_leggings", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:chameleon_scale_leggings", Integer.valueOf(12), Double.valueOf(0.0085), "adaptive"));
            });
            ModUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:chameleon_scale_boots", list -> {
                list.clear();
                list.addAll(List.of("cold_sweat:chameleon_scale_boots", Integer.valueOf(10), Double.valueOf(0.0085), "adaptive"));
            });
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b05a")) {
            ModUpdater.addConfigSetting(ItemSettingsConfig.BOILER_FUELS, List.of("minecraft:dried_kelp_block", Integer.valueOf(92)));
            ModUpdater.addConfigSetting(ItemSettingsConfig.HEARTH_FUELS, List.of("minecraft:dried_kelp_block", Integer.valueOf(92)));
        }
        if (ModUpdater.isBehind(configVersion, "2.4-b05b")) {
            ModUpdater.replaceConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:fire", list -> list.set(0, "#minecraft:fire"));
            ModUpdater.replaceConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "#minecraft:campfires,!#forge:soul_campfires", list -> list.set(0, "#minecraft:campfires"));
        }
        MainSettingsConfig.VERSION.set(version);
        MainSettingsConfig.save();
        ItemSettingsConfig.save();
        WorldSettingsConfig.save();
    }

    public static void updateFileNames() {
        for (File file : ConfigLoadingHandler.findFilesRecursive(FMLPaths.CONFIGDIR.get().resolve("coldsweat").toFile())) {
            if (!file.isFile()) continue;
            switch (file.getName()) {
                case "world_settings.toml": {
                    ModUpdater.renameFile(file, "world.toml");
                    break;
                }
                case "entity_settings.toml": {
                    ModUpdater.renameFile(file, "entity.toml");
                    break;
                }
                case "item_settings.toml": {
                    ModUpdater.renameFile(file, "item.toml");
                }
            }
        }
    }

    private static void renameFile(File file, String newName) {
        File newFile = file.toPath().resolveSibling(newName).toFile();
        try {
            Files.move((File)file, (File)newFile);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to rename file {} to {}", (Object)file, (Object)newFile, (Object)e);
        }
    }

    private static boolean isBehind(String version, String comparedTo) {
        boolean isBehind;
        boolean bl = isBehind = ModUpdater.compareVersions(version, comparedTo) < 0;
        if (isBehind) {
            ColdSweat.LOGGER.info("Last launched version {} is less than {}. Updating config settings...", (Object)version, (Object)comparedTo);
        }
        return isBehind;
    }

    public static int compareVersions(String version, String comparedTo) {
        int i;
        String[] v1Parts = version.split("\\.|\\-");
        String[] v2Parts = comparedTo.split("\\.|\\-");
        for (i = 0; i < v1Parts.length && i < v2Parts.length; ++i) {
            if (v1Parts[i].matches("\\d+") && v2Parts[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(v1Parts[i]);
                if (num1 == (num2 = Integer.parseInt(v2Parts[i]))) continue;
                return Integer.compare(num1, num2);
            }
            if (!v1Parts[i].startsWith("b") && v2Parts[i].startsWith("b")) {
                return 1;
            }
            if (v1Parts[i].startsWith("b") && !v2Parts[i].startsWith("b")) {
                return -1;
            }
            int result = ModUpdater.comparePreReleaseVersions(v1Parts[i], v2Parts[i]);
            if (result == 0) continue;
            return result;
        }
        if (v1Parts.length != v2Parts.length) {
            if (i == v1Parts.length && i < v2Parts.length && v2Parts[i].startsWith("b")) {
                return 1;
            }
            if (i == v2Parts.length && i < v1Parts.length && v1Parts[i].startsWith("b")) {
                return -1;
            }
        }
        return Integer.compare(v1Parts.length, v2Parts.length);
    }

    private static int comparePreReleaseVersions(String v1, String v2) {
        if (v1.startsWith("b") && v2.startsWith("b")) {
            return ModUpdater.compareWithSubVersions(v1.substring(1), v2.substring(1));
        }
        return v1.compareTo(v2);
    }

    private static int compareWithSubVersions(String v1, String v2) {
        String[] parts1 = v1.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        String[] parts2 = v2.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        for (int i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (parts1[i].matches("\\d+") && parts2[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(parts1[i]);
                if (num1 == (num2 = Integer.parseInt(parts2[i]))) continue;
                return Integer.compare(num1, num2);
            }
            int result = parts1[i].compareTo(parts2[i]);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    public static boolean replaceConfigSetting(CSConfigSpec.ConfigValue<List<? extends List<?>>> config, String key, Consumer<List<Object>> modifier) {
        ArrayList setting = new ArrayList((Collection)config.get());
        for (int i = 0; i < setting.size(); ++i) {
            ArrayList element = new ArrayList((Collection)setting.get(i));
            if (element.isEmpty() || !element.get(0).equals(key)) continue;
            try {
                modifier.accept(element);
                setting.set(i, element);
                config.set(setting);
                return true;
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Failed to update config setting {} for key '{}'", config.getPath(), (Object)key, (Object)e);
                return false;
            }
        }
        return false;
    }

    public static void addConfigSetting(CSConfigSpec.ConfigValue<List<? extends List<?>>> config, List<?> newSetting) {
        ArrayList setting = new ArrayList((Collection)config.get());
        if (setting.stream().noneMatch(entry -> !entry.isEmpty() && entry.get(0).equals(newSetting.get(0)))) {
            config.clearCache();
            setting.add(newSetting);
            config.set(setting);
        }
    }

    public static void removeConfigSetting(CSConfigSpec.ConfigValue<List<? extends List<? extends Object>>> config, String key) {
        ArrayList<List> setting = new ArrayList<List>((Collection)config.get());
        setting.removeIf(entry -> !entry.isEmpty() && entry.get(0).equals(key));
        config.set(setting);
    }
}

