/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public record EnchantmentRequirement(Either<TagKey<Enchantment>, Enchantment> enchantment, IntegerBounds level) {
    public static final Codec<EnchantmentRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrBuiltinCodec(Registries.f_256762_, ForgeRegistries.ENCHANTMENTS).fieldOf("enchantment").forGetter(requirement -> requirement.enchantment), (App)IntegerBounds.CODEC.optionalFieldOf("levels", (Object)IntegerBounds.NONE).forGetter(requirement -> requirement.level)).apply((Applicative)instance, EnchantmentRequirement::new));

    public boolean test(Enchantment enchantment, int level) {
        return (Boolean)this.enchantment.map(tag -> ForgeRegistries.ENCHANTMENTS.tags().getTag(tag).contains((Object)enchantment), enchantment::equals) != false && this.level.test(level);
    }

    public boolean test(Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            if (!this.test(entry.getKey(), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnchantmentRequirement that = (EnchantmentRequirement)obj;
        return this.enchantment.equals(that.enchantment) && this.level.equals(that.level);
    }
}

