/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class NegatableList<T> {
    private final List<T> requirements;
    private final List<T> exclusions;
    private final boolean singleton;
    private final boolean requireAll;
    private final boolean excludeAll;

    private static <T> Codec<NegatableList<T>> getCodec(Codec<T> codec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.listOf().optionalFieldOf("require", List.of()).forGetter(predicate -> predicate.requirements), (App)codec.listOf().optionalFieldOf("exclude", List.of()).forGetter(predicate -> predicate.exclusions), (App)Codec.BOOL.optionalFieldOf("require_all", (Object)false).forGetter(predicate -> predicate.requireAll), (App)Codec.BOOL.optionalFieldOf("exclude_all", (Object)false).forGetter(predicate -> predicate.excludeAll)).apply((Applicative)instance, NegatableList::new));
    }

    public static <T> Codec<NegatableList<T>> codec(Codec<T> codec) {
        Codec<NegatableList<T>> listCodec = NegatableList.getCodec(codec);
        return Codec.either(codec, listCodec).comapFlatMap(either -> {
            if (either.right().isPresent()) {
                return DataResult.success((Object)((NegatableList)either.right().get()));
            }
            return DataResult.success(new NegatableList(either.left().get()));
        }, list -> {
            if (list.singleton && list.exclusions.isEmpty()) {
                return Either.left(list.requirements.get(0));
            }
            return Either.right((Object)list);
        });
    }

    public static <T> Codec<NegatableList<T>> listCodec(Codec<T> codec) {
        Codec<NegatableList<T>> listCodec = NegatableList.getCodec(codec);
        return Codec.either((Codec)codec.listOf(), listCodec).comapFlatMap(either -> {
            if (either.right().isPresent()) {
                return DataResult.success((Object)((NegatableList)either.right().get()));
            }
            return DataResult.success(new NegatableList((Collection)either.left().get(), false, false));
        }, list -> {
            if (list.singleton && list.exclusions.isEmpty()) {
                return Either.left(list.requirements);
            }
            return Either.right((Object)list);
        });
    }

    public NegatableList() {
        this.requirements = new ArrayList<T>();
        this.exclusions = new ArrayList<T>();
        this.singleton = false;
        this.requireAll = false;
        this.excludeAll = false;
    }

    public NegatableList(T requirement) {
        this.requirements = new ArrayList<T>(List.of(requirement));
        this.exclusions = new ArrayList<T>();
        this.singleton = true;
        this.requireAll = false;
        this.excludeAll = false;
    }

    public NegatableList(Collection<T> requirements, boolean requireAll, boolean excludeAll) {
        this.requirements = new ArrayList<T>(requirements);
        this.exclusions = new ArrayList<T>();
        this.singleton = requirements.size() == 1;
        this.requireAll = requireAll;
        this.excludeAll = excludeAll;
    }

    public NegatableList(Collection<T> requirements) {
        this(requirements, false, false);
    }

    public NegatableList(Collection<T> requirements, Collection<T> exclusions, boolean requireAll, boolean excludeAll) {
        this.requirements = new ArrayList<T>(requirements);
        this.exclusions = new ArrayList<T>(exclusions);
        this.singleton = exclusions.isEmpty() && requirements.size() == 1;
        this.requireAll = requireAll;
        this.excludeAll = excludeAll;
    }

    public NegatableList(Collection<T> requirements, Collection<T> exclusions) {
        this(requirements, exclusions, false, false);
    }

    public List<T> requirements() {
        return this.requirements;
    }

    public List<T> exclusions() {
        return this.exclusions;
    }

    public void add(T element, boolean negate) {
        if (negate) {
            this.exclusions.add(element);
        } else {
            this.requirements.add(element);
        }
    }

    public boolean isEmpty() {
        return this.requirements.isEmpty() && this.exclusions.isEmpty();
    }

    public void forEach(Consumer<T> requirementAction, Consumer<T> exclusionAction) {
        this.requirements.forEach(requirementAction);
        this.exclusions.forEach(exclusionAction);
    }

    public <N> Optional<N> flatMap(Function<T, N> mapper, BinaryOperator<N> reducer, BiConsumer<N, N> remover) {
        Optional<N> requiredResult = this.requirements.stream().map(mapper).reduce(reducer);
        Optional<N> exclusionResult = this.exclusions.stream().map(mapper).reduce(reducer);
        if (requiredResult.isPresent() && exclusionResult.isPresent()) {
            remover.accept(requiredResult.get(), exclusionResult.get());
        }
        return requiredResult;
    }

    public <N> NegatableList<N> flatten(Function<T, NegatableList<N>> mapper) {
        List requirements = this.requirements.stream().map(mapper).flatMap(list -> list.requirements.stream()).toList();
        List exclusions = this.exclusions.stream().map(mapper).flatMap(list -> list.exclusions.stream()).toList();
        return new NegatableList(requirements, exclusions, this.requireAll, this.excludeAll);
    }

    public boolean test(Predicate<T> test) {
        boolean result;
        int i;
        block7: {
            if (!this.requirements.isEmpty()) {
                for (i = 0; i < this.requirements.size(); ++i) {
                    result = test.test(this.requirements.get(i));
                    if (this.requireAll && !result) {
                        return false;
                    }
                    if (this.requireAll || !result) {
                        continue;
                    }
                    break block7;
                }
                return this.requireAll;
            }
        }
        if (!this.exclusions.isEmpty()) {
            for (i = 0; i < this.exclusions.size(); ++i) {
                result = test.test(this.exclusions.get(i));
                if (this.excludeAll && !result) {
                    return true;
                }
                if (this.excludeAll || !result) continue;
                return false;
            }
            return !this.excludeAll;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NegatableList that = (NegatableList)obj;
        return this.requirements.equals(that.requirements) && this.exclusions.equals(that.exclusions);
    }

    public String toString() {
        return "NegatableList{requirements=" + this.requirements + ", exclusions=" + this.exclusions + "}";
    }
}

