/*
 * Decompiled with CFR 0.152.
 */
package com.bvengo.soundcontroller.gui;

import com.bvengo.soundcontroller.Translations;
import com.bvengo.soundcontroller.VolumeData;
import com.bvengo.soundcontroller.config.VolumeConfig;
import com.bvengo.soundcontroller.gui.VolumeListWidget;
import com.bvengo.soundcontroller.gui.VolumeWidgetEntry;
import com.bvengo.soundcontroller.gui.buttons.ToggleButtonWidget;
import java.util.Comparator;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class AllSoundOptionsScreen
extends class_4667 {
    VolumeConfig config = VolumeConfig.getInstance();
    protected final class_437 parent;
    private VolumeListWidget volumeListWidget;
    private class_342 searchField;
    private ToggleButtonWidget filterButton;
    private ToggleButtonWidget subtitlesButton;
    private boolean showModifiedOnly = false;

    public AllSoundOptionsScreen(class_437 parent, class_315 options) {
        super(parent, options, Translations.SOUND_SCREEN_TITLE);
        this.parent = parent;
        this.field_49503.method_48995(this.field_49503.method_48998() + 28);
    }

    protected void method_25426() {
        this.addSearchField();
        this.addFilterButton();
        this.addSubtitlesButton();
        this.addVolumeList();
        this.addDoneButton();
        this.method_48265((class_364)this.searchField);
    }

    protected void method_60325() {
    }

    private void addSearchField() {
        this.searchField = new class_342(this.field_22793, 80, 35, this.field_22789 - 167, 20, Translations.SEARCH_FIELD_PLACEHOLDER);
        this.searchField.method_1863(serverName -> this.loadOptions());
        this.method_25429((class_364)this.searchField);
    }

    private void addFilterButton() {
        this.filterButton = new ToggleButtonWidget("filter", this.searchField.method_55442() + 8, 35, 20, 20, button -> {
            this.showModifiedOnly = !this.showModifiedOnly;
            this.loadOptions();
        }, false);
        this.filterButton.method_47400(class_7919.method_47407((class_2561)Translations.FILTER_BUTTON_TOOLTIP));
        this.method_37063((class_364)this.filterButton);
    }

    private void addSubtitlesButton() {
        this.subtitlesButton = new ToggleButtonWidget("subtitles", this.filterButton.method_55442() + 4, 35, 20, 20, button -> this.config.toggleSubtitles(), this.config.areSubtitlesEnabled());
        this.subtitlesButton.method_47400(class_7919.method_47407((class_2561)Translations.SUBTITLES_BUTTON_TOOLTIP));
        this.method_37063((class_364)this.subtitlesButton);
    }

    private void addVolumeList() {
        this.volumeListWidget = new VolumeListWidget(this.field_22787, this.field_22789, this.searchField.method_55443() + 32, this);
        this.loadOptions();
        this.method_37063((class_364)this.volumeListWidget);
    }

    private void addDoneButton() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 27, 200, 20).method_46431());
    }

    private void loadOptions() {
        this.volumeListWidget.method_25339();
        this.volumeListWidget.method_44382(0.0);
        String search = this.searchField.method_1882().toLowerCase();
        this.config.getVolumes().values().stream().filter(volumeData -> volumeData.inFilter(search, this.showModifiedOnly)).sorted(Comparator.comparing(v -> v.getId().toString())).forEach(volumeData -> {
            VolumeWidgetEntry volumeEntry = new VolumeWidgetEntry((VolumeData)volumeData, (class_437)this, this.field_21336);
            this.volumeListWidget.addWidgetEntry(volumeEntry);
        });
    }

    public void method_25432() {
        this.config.save();
        this.searchField.method_1852("");
    }

    public void method_25410(class_310 client, int width, int height) {
        String search = this.searchField.method_1882();
        this.field_22789 = width;
        this.field_22790 = height;
        this.method_37067();
        this.method_48267();
        this.method_25426();
        this.searchField.method_1852(search);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        context.method_27535(this.field_22793, Translations.SEARCH_FIELD_TITLE, 32, 40, 0xA0A0A0);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
    }
}

