/*
 * Decompiled with CFR 0.152.
 */
package jp.atelier_kanata.torchlaunchermod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import jp.atelier_kanata.torchlaunchermod.client.renderer.entity.state.TorchLauncherProjectileRenderState;
import jp.atelier_kanata.torchlaunchermod.entity.TorchLauncherProjectileEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.RenderShape;

public class TorchLauncherProjectileRenderer
extends EntityRenderer<TorchLauncherProjectileEntity, TorchLauncherProjectileRenderState> {
    public TorchLauncherProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
    }

    public TorchLauncherProjectileRenderState createRenderState() {
        return new TorchLauncherProjectileRenderState();
    }

    public void extractRenderState(TorchLauncherProjectileEntity entity, TorchLauncherProjectileRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        BlockPos blockPos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
        reusedState.movingBlockRenderState.level = entity.level();
        reusedState.movingBlockRenderState.biome = entity.level().getBiome(blockPos);
        reusedState.movingBlockRenderState.blockPos = blockPos;
        reusedState.movingBlockRenderState.blockState = entity.getBlockState();
    }

    public boolean shouldRender(TorchLauncherProjectileEntity entity, Frustum camera, double camX, double camY, double camZ) {
        return !super.shouldRender((Entity)entity, camera, camX, camY, camZ) ? false : entity.getBlockState() != entity.level().getBlockState(entity.blockPosition());
    }

    public void submit(TorchLauncherProjectileRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.movingBlockRenderState.blockState.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(-0.5, 0.0, -0.5);
        submitNodeCollector.submitMovingBlock(poseStack, renderState.movingBlockRenderState);
        poseStack.popPose();
        super.submit((EntityRenderState)renderState, poseStack, submitNodeCollector, cameraRenderState);
    }
}

