/*
 * Decompiled with CFR 0.152.
 */
package jp.atelier_kanata.torchlaunchermod.entity;

import javax.annotation.Nullable;
import jp.atelier_kanata.torchlaunchermod.registry.TorchLauncherModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public class TorchLauncherProjectileEntity
extends Projectile {
    private static final EntityDataAccessor<BlockPos> DATA_START_BLOCK_POS = SynchedEntityData.defineId(TorchLauncherProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEM_STACK = SynchedEntityData.defineId(TorchLauncherProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> DATA_IN_GROUND = SynchedEntityData.defineId(TorchLauncherProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public TorchLauncherProjectileEntity(EntityType<? extends TorchLauncherProjectileEntity> entityType, Level level) {
        super(entityType, level);
    }

    public TorchLauncherProjectileEntity(Level level, @Nullable Entity shooter, double x, double y, double z, ItemStack itemStack) {
        super(TorchLauncherModEntities.TORCH_LAUNCHER_PROJECTILE_ENTITY.get(), level);
        this.setOwner(shooter);
        this.setPos(x, y, z);
        this.setStartBlockPos(this.blockPosition());
        this.setItemStack(itemStack);
    }

    public BlockPos getStartBlockPos() {
        return (BlockPos)this.entityData.get(DATA_START_BLOCK_POS);
    }

    private void setStartBlockPos(BlockPos blockPos) {
        this.entityData.set(DATA_START_BLOCK_POS, (Object)blockPos);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.entityData.get(DATA_ID_ITEM_STACK);
    }

    private void setItemStack(ItemStack itemStack) {
        ItemStack itemStackCopy = itemStack.copy();
        itemStackCopy.remove(DataComponents.INTANGIBLE_PROJECTILE);
        this.entityData.set(DATA_ID_ITEM_STACK, (Object)itemStackCopy);
    }

    public BlockState getBlockState() {
        return Block.byItem((Item)this.getItemStack().getItem()).defaultBlockState();
    }

    private boolean isInGround() {
        return (Boolean)this.entityData.get(DATA_IN_GROUND);
    }

    private void setInGround(boolean inGround) {
        this.entityData.set(DATA_IN_GROUND, (Object)inGround);
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockPos setBlockPos;
        super.onHitBlock(result);
        this.setInGround(true);
        if (this.level().isClientSide()) {
            return;
        }
        if (result.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos hitBlockPos = result.getBlockPos();
        if (this.level().getBlockState(hitBlockPos).isAir()) {
            return;
        }
        Direction direction = result.getDirection();
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: {
                BlockPos blockPos = hitBlockPos.above();
                break;
            }
            case EAST: {
                BlockPos blockPos = hitBlockPos.east();
                break;
            }
            case WEST: {
                BlockPos blockPos = hitBlockPos.west();
                break;
            }
            case SOUTH: {
                BlockPos blockPos = hitBlockPos.south();
                break;
            }
            case NORTH: {
                BlockPos blockPos = hitBlockPos.north();
                break;
            }
            case DOWN: {
                BlockPos blockPos = setBlockPos = hitBlockPos.below();
            }
        }
        if (!this.level().getBlockState(setBlockPos).canBeReplaced()) {
            this.dropItemStack();
        } else {
            BlockState setBlockState = this.createTorchBlockState(direction);
            if (setBlockState == null || !setBlockState.canSurvive((LevelReader)this.level(), setBlockPos)) {
                this.dropItemStack();
            } else {
                this.level().setBlock(setBlockPos, setBlockState, 3);
                this.gameEvent((Holder)GameEvent.BLOCK_PLACE, this.getOwner());
                this.playSound(setBlockState.getSoundType((LevelReader)this.level(), setBlockPos, null).getPlaceSound(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            }
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    private void dropItemStack() {
        this.spawnAtLocation((ServerLevel)this.level(), this.getItemStack().copy());
    }

    private BlockState createTorchBlockState(Direction direction) {
        if (this.getItemStack().is(Items.TORCH)) {
            if (direction == Direction.UP) {
                return Blocks.TORCH.defaultBlockState();
            }
            if (direction == Direction.DOWN) {
                return null;
            }
            return (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction);
        }
        if (this.getItemStack().is(Items.SOUL_TORCH)) {
            if (direction == Direction.UP) {
                return Blocks.SOUL_TORCH.defaultBlockState();
            }
            if (direction == Direction.DOWN) {
                return null;
            }
            return (BlockState)Blocks.SOUL_WALL_TORCH.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction);
        }
        Item item = this.getItemStack().getItem();
        return item instanceof BlockItem ? Block.byItem((Item)item).defaultBlockState() : null;
    }

    protected boolean canHitEntity(Entity target) {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    private boolean shouldFall() {
        return this.isInGround() && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    public void move(MoverType type, Vec3 pos) {
        super.move(type, pos);
        if (type != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    private void startFalling() {
        this.setInGround(false);
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
    }

    public void tick() {
        VoxelShape voxelShape;
        Vec3 deltaMovement = this.getDeltaMovement();
        BlockPos blockPos = this.blockPosition();
        BlockState blockState = this.level().getBlockState(blockPos);
        if (!blockState.isAir() && !(voxelShape = blockState.getCollisionShape((BlockGetter)this.level(), blockPos)).isEmpty()) {
            Vec3 entityPos = this.position();
            for (AABB aabb : voxelShape.toAabbs()) {
                if (!aabb.move(blockPos).contains(entityPos)) continue;
                this.setDeltaMovement(Vec3.ZERO);
                this.setInGround(true);
                break;
            }
        }
        if (!this.isInGround()) {
            Vec3 entityPos = this.position();
            this.setXRot(TorchLauncherProjectileEntity.lerpRotation((float)this.getXRot(), (float)((float)(Mth.atan2((double)deltaMovement.y, (double)deltaMovement.horizontalDistance()) * 180.0 / 3.1415927410125732))));
            this.setYRot(TorchLauncherProjectileEntity.lerpRotation((float)this.getYRot(), (float)((float)(Mth.atan2((double)deltaMovement.x, (double)deltaMovement.z) * 180.0 / 3.1415927410125732))));
            BlockHitResult blockHitResult = this.level().clipIncludingBorder(new ClipContext(entityPos, entityPos.add(deltaMovement), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            this.stepMoveAndHit(blockHitResult);
            this.applyInertia(0.99f);
            this.applyGravity();
            super.tick();
        }
    }

    private void stepMoveAndHit(BlockHitResult blockHitResult) {
        Vec3 oldEntityPos = this.position();
        Vec3 newEntityPos = blockHitResult.getLocation();
        this.setPos(newEntityPos);
        this.applyEffectsFromBlocks(oldEntityPos, newEntityPos);
        if (this.portalProcess != null && this.portalProcess.isInsidePortalThisTick()) {
            this.handlePortal();
        }
        if (blockHitResult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)blockHitResult)) {
            this.hitTargetOrDeflectSelf((HitResult)blockHitResult);
            this.hasImpulse = true;
        }
    }

    private void applyInertia(float inertia) {
        this.setDeltaMovement(this.getDeltaMovement().scale((double)inertia));
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isAttackable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_START_BLOCK_POS, (Object)BlockPos.ZERO);
        builder.define(DATA_ID_ITEM_STACK, (Object)this.getDefaultItemStack());
        builder.define(DATA_IN_GROUND, (Object)false);
    }

    private ItemStack getDefaultItemStack() {
        return new ItemStack((ItemLike)Items.TORCH);
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.store("itemStack", ItemStack.CODEC, (Object)this.getItemStack());
        output.putBoolean("inGround", this.isInGround());
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setItemStack(input.read("itemStack", ItemStack.CODEC).orElse(this.getDefaultItemStack()));
        this.setInGround(input.getBooleanOr("inGround", false));
    }
}

