/*
 * Decompiled with CFR 0.152.
 */
package jp.atelier_kanata.torchlaunchermod.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import jp.atelier_kanata.torchlaunchermod.TorchLauncherModConfig;
import jp.atelier_kanata.torchlaunchermod.entity.TorchLauncherProjectileEntity;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class TorchLauncherItem
extends ProjectileWeaponItem {
    public TorchLauncherItem(Item.Properties properties) {
        super(properties);
    }

    public boolean releaseUsing(ItemStack weaponItemStack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        ItemStack projectileItemStack = player.getProjectile(weaponItemStack);
        if (projectileItemStack.isEmpty()) {
            return false;
        }
        int charge = this.getUseDuration(weaponItemStack, livingEntity) - timeLeft;
        if ((charge = EventHooks.onArrowLoose((ItemStack)weaponItemStack, (Level)level, (Player)player, (int)charge, (boolean)true)) < 0) {
            return false;
        }
        float power = TorchLauncherItem.getPowerForTime(charge);
        if ((double)power < 0.1) {
            return false;
        }
        List drewProjectileItemStackList = TorchLauncherItem.draw((ItemStack)weaponItemStack, (ItemStack)projectileItemStack, (LivingEntity)player);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!drewProjectileItemStackList.isEmpty()) {
                this.shoot(serverLevel, (LivingEntity)player, player.getUsedItemHand(), weaponItemStack, drewProjectileItemStackList, power * 3.0f, 1.0f, false, null);
            }
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + power * 0.5f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return true;
    }

    private static float getPowerForTime(float charge) {
        float f = charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, LivingEntity target) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    protected Projectile createProjectile(Level level, LivingEntity livingEntity, ItemStack weaponItemStack, ItemStack ammoItemStack, boolean isCrit) {
        return new TorchLauncherProjectileEntity(level, (Entity)livingEntity, livingEntity.getX(), livingEntity.getEyeY(), livingEntity.getZ(), ammoItemStack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStackInHand;
        boolean hasProjectile = !player.getProjectile(itemStackInHand = player.getItemInHand(interactionHand)).isEmpty();
        InteractionResult result = EventHooks.onArrowNock((ItemStack)itemStackInHand, (Level)level, (Player)player, (InteractionHand)interactionHand, (boolean)hasProjectile);
        if (result != null) {
            return result;
        }
        if (!player.hasInfiniteMaterials() && !hasProjectile) {
            return InteractionResult.FAIL;
        }
        player.startUsingItem(interactionHand);
        return InteractionResult.CONSUME;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return itemStack -> ((List)TorchLauncherModConfig.LAUNCHABLE_BLOCKS.get()).stream().anyMatch(name -> BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).equals((Object)ResourceLocation.parse((String)name)));
    }

    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack weaponItemStack) {
        return Items.TORCH.getDefaultInstance();
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }
}

