/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set.mud;

import java.util.Collection;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.mud.MudType;
import net.mehvahdjukaar.stone_zone.api.set.mud.VanillaMudTypes;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class MudTypeRegistry
extends BlockTypeRegistry<MudType> {
    public static final MudTypeRegistry INSTANCE = new MudTypeRegistry();

    public MudTypeRegistry() {
        super(MudType.class, "mud_type");
    }

    public MudType register(MudType vanillaType) {
        return (MudType)super.register((BlockType)vanillaType);
    }

    public MudType getDefaultType() {
        return VanillaMudTypes.MUD;
    }

    public Optional<MudType> detectTypeFromBlock(Block baseblock, ResourceLocation baseRes) {
        String path = baseRes.getPath();
        if (path.matches("[a-z]+_mud_bricks") && baseblock.defaultBlockState().instrument() == NoteBlockInstrument.BASEDRUM && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.getNamespace())) {
            String mudName = path.substring(0, path.length() - 7);
            String mudAlt = mudName + "_mud";
            ResourceLocation idBlockType = baseRes.withPath(mudName);
            ResourceLocation idBlockTypeAlt = baseRes.withPath(mudAlt);
            if (!this.valuesReg.containsKey(idBlockType) && !this.valuesReg.containsKey(idBlockTypeAlt)) {
                Optional opt = BuiltInRegistries.BLOCK.getOptional(baseRes.withPath(mudName));
                Optional alt = BuiltInRegistries.BLOCK.getOptional(baseRes.withPath(mudAlt));
                if (opt.isPresent()) {
                    return Optional.of(new MudType(baseRes.withPath(mudName), (Block)opt.get()));
                }
                if (alt.isPresent()) {
                    return Optional.of(new MudType(baseRes.withPath(mudAlt), (Block)alt.get()));
                }
            }
        }
        return Optional.empty();
    }

    public MudType.Finder addSimpleFinder(ResourceLocation mudTypeId) {
        MudType.Finder finder = new MudType.Finder(mudTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public MudType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(ResourceLocation.parse((String)typeId));
    }

    public MudType.Finder addSimpleFinder(String namespace, String nameMudType) {
        return this.addSimpleFinder(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)nameMudType));
    }

    public int priority() {
        return 110;
    }

    @Deprecated(forRemoval=true)
    public static MudType getMudType() {
        return VanillaMudTypes.MUD;
    }

    @Deprecated(forRemoval=true)
    public static MudType getValue(String mudTypeId) {
        return (MudType)INSTANCE.get(ResourceLocation.parse((String)mudTypeId));
    }

    @Deprecated(forRemoval=true)
    public static Collection<MudType> getTypes() {
        return INSTANCE.getValues();
    }
}

