/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set.stone;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.set.RockType;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneTypeRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public class StoneType
extends RockType {
    public final Block stone;

    protected StoneType(ResourceLocation id, Block stone) {
        super(id, stone);
        this.stone = stone;
    }

    public String getTranslationKey() {
        return "stone_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
    }

    @Override
    public ItemLike mainChild() {
        return this.stone;
    }

    @Override
    public Block bricksOrStone() {
        Block bricks = this.getBlockOfThis("bricks");
        return bricks != null ? bricks : this.stone;
    }

    public static Block findStone(ResourceLocation id) {
        ResourceLocation[] tests = StoneType.makeKnownIDConventions(id, "", "stone");
        return (Block)Utils.findFirstInRegistry((Registry)BuiltInRegistries.BLOCK, (ResourceLocation[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<StoneType> {
        private Supplier<Block> stoneFinder;

        public Finder(ResourceLocation id) {
            super(id, (BlockTypeRegistry)StoneTypeRegistry.INSTANCE);
            this.stone(() -> StoneType.findStone(id));
        }

        public Finder stone(Supplier<Block> stoneFinder) {
            this.stoneFinder = stoneFinder;
            return this;
        }

        public Finder stone(ResourceLocation id) {
            return this.stone(() -> (Block)BuiltInRegistries.BLOCK.getOptional(id).orElseThrow(() -> new IllegalStateException("Failed to find stone block: " + String.valueOf(id))));
        }

        public Finder stone(String nameStoneOrId) {
            return this.stone(Utils.idWithOptionalNamespace((String)nameStoneOrId, (String)this.id.getNamespace()));
        }

        public Finder stoneAffix(String prefix, String suffix) {
            return this.stone(prefix + this.id.getPath() + suffix);
        }

        public Finder stoneSuffix(String suffix) {
            return this.stone(this.id.getPath() + suffix);
        }

        @ApiStatus.Internal
        public Optional<StoneType> get() {
            if (PlatHelper.isModLoaded((String)this.id.getNamespace())) {
                try {
                    Block stone = (Block)Preconditions.checkNotNull((Object)this.stoneFinder.get(), (String)"Manual Finder - failed to find a stone block for {}", (Object)this.id);
                    StoneType stoneType = new StoneType(this.id, stone);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            stoneType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            StoneZone.LOGGER.warn("Failed to get children for StoneType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(stoneType);
                }
                catch (Exception e) {
                    StoneZone.LOGGER.warn("Failed to find custom StoneType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

