/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set.stone;

import java.util.Collection;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneType;
import net.mehvahdjukaar.stone_zone.api.set.stone.VanillaStoneTypes;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class StoneTypeRegistry
extends BlockTypeRegistry<StoneType> {
    public static final StoneTypeRegistry INSTANCE = new StoneTypeRegistry();

    public StoneTypeRegistry() {
        super(StoneType.class, "stone_type");
    }

    protected StoneType register(StoneType vanillaType) {
        return (StoneType)super.register((BlockType)vanillaType);
    }

    public StoneType getDefaultType() {
        return VanillaStoneTypes.STONE;
    }

    public Optional<StoneType> detectTypeFromBlock(Block baseblock, ResourceLocation baseRes) {
        String blockPath = baseRes.getPath();
        if (baseRes.getNamespace().matches("tfc|afc") && blockPath.matches("rock/bricks/\\w+") && baseblock.defaultBlockState().instrument() == NoteBlockInstrument.BASEDRUM) {
            int index = blockPath.lastIndexOf("/");
            String stoneName = blockPath.substring(index + 1);
            Optional opt = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.fromNamespaceAndPath((String)baseRes.getNamespace(), (String)blockPath.replace("bricks", "raw")));
            if (opt.isPresent()) {
                return Optional.of(new StoneType(baseRes.withPath(stoneName), (Block)opt.get()));
            }
        }
        if (!HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.getNamespace())) {
            if (blockPath.matches("[a-z]+_(?:stone_)?bricks?")) {
                boolean noWoodType;
                String stoneName = blockPath.substring(0, blockPath.length() - 7);
                stoneAlt = stoneName + "_stone";
                idBlockType = baseRes.withPath(stoneName);
                ResourceLocation idBlockTypeAlt = baseRes.withPath(stoneAlt);
                boolean isStoneTypeNotBlacklisted = !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.withPath(stoneName).toString()) && !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.withPath(stoneAlt).toString());
                boolean noDustType = !BuiltInRegistries.ITEM.containsKey(ResourceLocation.fromNamespaceAndPath((String)baseRes.getNamespace(), (String)blockPath.replaceAll("(?<name>[a-z]+_)\\w+", "${name}dust")));
                boolean noOreType = !BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)baseRes.getNamespace(), (String)blockPath.replaceAll("(?<name>[a-z]+_)\\w+", "${name}ore")));
                boolean bl = noWoodType = !BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)baseRes.getNamespace(), (String)blockPath.replaceAll("(?<name>[a-z]+_)[a-z]+", "${name}log")));
                if (!this.valuesReg.containsKey(idBlockType) && !this.valuesReg.containsKey(idBlockTypeAlt) && isStoneTypeNotBlacklisted && noDustType && noOreType && noWoodType) {
                    Optional opt = BuiltInRegistries.BLOCK.getOptional(idBlockType);
                    Optional alt = BuiltInRegistries.BLOCK.getOptional(idBlockTypeAlt);
                    if (opt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.withPath(stoneName), (Block)opt.get()));
                    }
                    if (alt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.withPath(stoneAlt), (Block)alt.get()));
                    }
                }
            } else if (blockPath.matches("polished_[a-z]+(?:_stone)?")) {
                boolean isStoneTypeBlacklisted;
                String stoneName = blockPath.replace("polished_", "");
                stoneAlt = stoneName + "_stone";
                idBlockType = baseRes.withPath(stoneName);
                ResourceLocation idBlockTypeAlt = baseRes.withPath(stoneAlt);
                boolean bl = isStoneTypeBlacklisted = !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.withPath(stoneName).toString()) && !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.withPath(stoneAlt).toString());
                if (!this.valuesReg.containsKey(idBlockType) && !this.valuesReg.containsKey(idBlockTypeAlt) && isStoneTypeBlacklisted) {
                    Optional opt = BuiltInRegistries.BLOCK.getOptional(idBlockType);
                    Optional alt = BuiltInRegistries.BLOCK.getOptional(idBlockTypeAlt);
                    if (opt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.withPath(stoneName), (Block)opt.get()));
                    }
                    if (alt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.withPath(stoneAlt), (Block)alt.get()));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public StoneType.Finder addSimpleFinder(ResourceLocation stoneTypeId) {
        StoneType.Finder finder = new StoneType.Finder(stoneTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public StoneType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(ResourceLocation.parse((String)typeId));
    }

    public StoneType.Finder addSimpleFinder(String namespace, String nameStoneType) {
        return this.addSimpleFinder(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)nameStoneType));
    }

    public int priority() {
        return 110;
    }

    @Deprecated(forRemoval=true)
    public static StoneType getStoneType() {
        return StoneTypeRegistry.getValue("stone");
    }

    @Deprecated(forRemoval=true)
    public static StoneType getAndesiteType() {
        return StoneTypeRegistry.getValue("andesite");
    }

    @Deprecated(forRemoval=true)
    public static StoneType getValue(String stoneTypeId) {
        return (StoneType)INSTANCE.get(ResourceLocation.parse((String)stoneTypeId));
    }

    @Deprecated(forRemoval=true)
    public static Collection<StoneType> getTypes() {
        return INSTANCE.getValues();
    }
}

