/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.common_classes;

import net.mehvahdjukaar.stone_zone.api.set.stone.StoneType;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.stone.VanillaStoneTypes;
import net.mehvahdjukaar.stone_zone.common_classes.CompatTrappedChestBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CompatChestBlockEntity
extends ChestBlockEntity {
    private final StoneType stoneType;
    private final boolean trapped;
    private float[] tint = null;

    public CompatChestBlockEntity(BlockEntityType<?> arg, BlockPos pos, BlockState state) {
        super(arg, pos, state);
        StoneType stone = (StoneType)StoneTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)state.getBlock());
        this.stoneType = stone == null ? VanillaStoneTypes.STONE : stone;
        this.trapped = state.getBlock() instanceof CompatTrappedChestBlock;
    }

    public float[] getTint() {
        if (this.tint == null) {
            int color = Minecraft.getInstance().getBlockColors().getColor(this.stoneType.stone.defaultBlockState(), (BlockAndTintGetter)this.level, this.worldPosition, 0);
            this.tint = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f};
        }
        return this.tint;
    }

    public StoneType getStoneType() {
        return this.stoneType;
    }

    protected void signalOpenCount(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, int eventId, int eventParam) {
        super.signalOpenCount(level, pos, state, eventId, eventParam);
        if (this.trapped && eventId != eventParam) {
            Block block = state.getBlock();
            level.updateNeighborsAt(pos, block);
            level.updateNeighborsAt(pos.below(), block);
        }
    }

    public boolean isTrapped() {
        return this.trapped;
    }
}

