/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.common_classes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneType;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneTypeRegistry;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CompatChestBlockRenderer
extends ChestRenderer<CompatChestBlockEntity> {
    public static final ResourceLocation CHEST_SHEET = ResourceLocation.parse((String)"textures/atlas/chest.png");
    private final Map<StoneType, Material> single = new HashMap<StoneType, Material>();
    private final Map<StoneType, Material> left = new HashMap<StoneType, Material>();
    private final Map<StoneType, Material> right = new HashMap<StoneType, Material>();
    private final Map<StoneType, Material> trapped = new HashMap<StoneType, Material>();
    private final Map<StoneType, Material> trapped_left = new HashMap<StoneType, Material>();
    private final Map<StoneType, Material> trapped_right = new HashMap<StoneType, Material>();

    public CompatChestBlockRenderer(BlockEntityRendererProvider.Context context, String shortenedId) {
        super(context);
        Iterator iterator = StoneTypeRegistry.INSTANCE.iterator();
        while (iterator.hasNext()) {
            StoneType w = (StoneType)((Object)iterator.next());
            if (w.isVanilla()) continue;
            String path = "entity/chest/" + shortenedId + "/" + w.getAppendableId() + "_chest";
            String trapped_path = "entity/chest/" + shortenedId + "/" + w.getAppendableId() + "_trapped_chest";
            if (w.isVanilla()) continue;
            this.single.put(w, new Material(CHEST_SHEET, StoneZone.res(path)));
            this.left.put(w, new Material(CHEST_SHEET, StoneZone.res(path + "_left")));
            this.right.put(w, new Material(CHEST_SHEET, StoneZone.res(path + "_right")));
            this.trapped.put(w, new Material(CHEST_SHEET, StoneZone.res(trapped_path)));
            this.trapped_left.put(w, new Material(CHEST_SHEET, StoneZone.res(trapped_path + "_left")));
            this.trapped_right.put(w, new Material(CHEST_SHEET, StoneZone.res(trapped_path + "_right")));
        }
    }

    @NotNull
    protected Material getMaterial(CompatChestBlockEntity blockEntity, ChestType chestType) {
        StoneType w = blockEntity.getStoneType();
        if (blockEntity.isTrapped()) {
            return switch (chestType) {
                case ChestType.LEFT -> this.trapped_left.get((Object)w);
                case ChestType.RIGHT -> this.trapped_right.get((Object)w);
                default -> this.trapped.get((Object)w);
            };
        }
        return switch (chestType) {
            case ChestType.LEFT -> this.left.get((Object)w);
            case ChestType.RIGHT -> this.right.get((Object)w);
            default -> this.single.get((Object)w);
        };
    }

    public void render(CompatChestBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)blockstate.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        Block flag1 = blockstate.getBlock();
        if (flag1 instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)flag1;
            boolean flag1x = chesttype != ChestType.SINGLE;
            poseStack.pushPose();
            float f = ((Direction)blockstate.getValue((Property)ChestBlock.FACING)).toYRot();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-f));
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.combine(blockstate, level, blockEntity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float f1 = ((Float2FloatFunction)neighborcombineresult.apply(ChestBlock.opennessCombiner((LidBlockEntity)blockEntity))).get(partialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            Material material = this.getMaterial(blockEntity, chesttype);
            VertexConsumer vertexconsumer = material.buffer(buffer, RenderType::entityCutout);
            float[] color = blockEntity.getTint();
            if (flag1x) {
                if (chesttype == ChestType.LEFT) {
                    this.render(poseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, packedOverlay);
                } else {
                    this.render(poseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, packedOverlay);
                }
            } else {
                this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, packedOverlay);
            }
            poseStack.popPose();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float lidAngle, int packedLight, int packedOverlay) {
        lockPart.xRot = lidPart.xRot = -(lidAngle * 1.5707964f);
        lidPart.render(poseStack, consumer, packedLight, packedOverlay);
        lockPart.render(poseStack, consumer, packedLight, packedOverlay);
        bottomPart.render(poseStack, consumer, packedLight, packedOverlay);
    }

    public static void register(ClientHelper.BlockEntityRendererEvent event, BlockEntityType<CompatChestBlockEntity> tile, String s) {
        event.register(tile, c -> new CompatChestBlockRenderer(c, s));
    }
}

