/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.misc;

import java.util.Set;
import net.mehvahdjukaar.stone_zone.api.set.mud.MudType;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneType;
import net.mehvahdjukaar.stone_zone.configs.UnsafeDisablerConfigs;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class HardcodedBlockType {
    public static String stoneIdentify;
    public static String mudIdentify;
    public static String stoneTypeFromMod;
    public static String mudTypeFromMod;
    public static String modId;
    public static String supportedBlockName;
    public static final Set<String> BLACKLISTED_MODS;
    public static final Set<String> BLACKLISTED_STONETYPES;
    private static final Set<String> VANILLA_STONES;
    private static final Set<String> VANILLA_MUDS;

    @Nullable
    public static Boolean isStoneBlockAlreadyRegistered(String entrySetId, String blockName, StoneType stoneType, String ModId) {
        stoneIdentify = stoneType.getId().toString();
        stoneTypeFromMod = stoneType.getNamespace();
        modId = ModId;
        supportedBlockName = blockName;
        if (HardcodedBlockType.isStoneFrom("waystones", "", "", "prismarine_waystone").booleanValue()) {
            return false;
        }
        if (UnsafeDisablerConfigs.stoneTypeList.get().stream().anyMatch(stoneIdentify::matches)) {
            return true;
        }
        if (UnsafeDisablerConfigs.entrySetList.get().stream().anyMatch(entrySetId::matches)) {
            return true;
        }
        if (HardcodedBlockType.isKnownVanillaStone(stoneType)) {
            return true;
        }
        if (HardcodedBlockType.isStoneFrom("quark", "quark", "", "pillar").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isStoneFrom("create", "create", "", "pillar").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isStoneFrom("decorative_blocks", "decorative_blocks", "", "pillar").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isStoneFrom("quark|create|decorative_blocks", "", "", "pillar").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isStoneFrom("create", "quark", "", "cut_soul_sandstone").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isStoneFrom("rechiseled", "blockus", "", "squares").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isStoneFrom("create", "", "quark:limestone|wetland_whimsy:limestone|geologicexpansion:limestone|tfc:limestone", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isStoneFrom("", "tfc", "", "").booleanValue()) {
            return false;
        }
        return null;
    }

    @Nullable
    public static Boolean isMudBlockAlreadyRegistered(String entrySetId, String blockName, MudType mudType, String ModId) {
        mudIdentify = mudType.getId().toString();
        mudTypeFromMod = mudType.getNamespace();
        modId = ModId;
        supportedBlockName = blockName;
        if (UnsafeDisablerConfigs.mudTypeList.get().stream().anyMatch(mudIdentify::matches)) {
            return true;
        }
        if (UnsafeDisablerConfigs.entrySetList.get().stream().anyMatch(entrySetId::matches)) {
            return true;
        }
        if (HardcodedBlockType.isKnownVanillaMud(mudType)) {
            return true;
        }
        return null;
    }

    public static Boolean isStoneFrom(String supportedModId, String stonetypeFromMod, String stoneTypeId, String supportedBlockId) {
        String[] expressions = new String[]{supportedModId, stonetypeFromMod, stoneTypeId, supportedBlockId};
        String[] values = new String[]{modId, stoneTypeFromMod, stoneIdentify, supportedBlockName};
        for (int idx = 0; idx < values.length; ++idx) {
            boolean mismatched;
            if (expressions[idx].isEmpty()) continue;
            boolean bl = mismatched = !values[idx].matches(expressions[idx]) && !values[idx].contains(expressions[idx]);
            if (!mismatched) continue;
            return false;
        }
        return true;
    }

    public static Boolean isMudFrom(String supportedModId, String mudtypeFromMod, String mudTypeId, String supportedBlockId) {
        String[] expressions = new String[]{supportedModId, mudtypeFromMod, mudTypeId, supportedBlockId};
        String[] values = new String[]{modId, mudTypeFromMod, mudIdentify, supportedBlockName};
        for (int idx = 0; idx < values.length; ++idx) {
            boolean mismatched;
            if (expressions[idx].isEmpty()) continue;
            boolean bl = mismatched = !values[idx].matches(expressions[idx]) && !values[idx].contains(expressions[idx]);
            if (!mismatched) continue;
            return false;
        }
        return true;
    }

    public static boolean isKnownVanillaStone(StoneType stoneType) {
        ResourceLocation id = stoneType.getId();
        if (id.getNamespace().equals("minecraft")) {
            return VANILLA_STONES.contains(id.getPath());
        }
        return false;
    }

    public static boolean isKnownVanillaMud(MudType mudType) {
        ResourceLocation id = mudType.getId();
        if (id.getNamespace().equals("minecraft")) {
            return VANILLA_MUDS.contains(id.getPath());
        }
        return false;
    }

    static {
        BLACKLISTED_MODS = Set.of("immersive_weathering", "chipped", "create_confectionery", "rgbblocks", "opalescence");
        BLACKLISTED_STONETYPES = Set.of("quark:shingles", "outer_end:himmel", "quark:midori", "twigs:silt", "supplementaries:ash", "blue_skies:brumble", "nifty:concrete", "blocksyouneed_luna:bluestone", "blocksyouneed_luna:scorchcobble", "sullysmod:amber", "endergetic:eumus", "minecraft:mud", "enlightened_end:chorloam", "desire:polished_stone", "desire:chiseled_stone", "create_dd:cut_stone", "stoneexpansion:cut_stone", "stoneexpansion:mossy_stone", "stoneexpansion:smooth_stone", "stoneexpansion:polished_stone", "minecraft:infested_stone", "ars_nouveau:sconce", "rgbblocks:prismarine");
        VANILLA_STONES = Set.of("stone", "andesite", "granite", "diorite", "tuff", "calcite", "blackstone", "sandstone", "basalt", "deepslate", "prismarine", "nether", "end_stone");
        VANILLA_MUDS = Set.of("mud");
    }
}

