/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.modules.neoforge.stone_chest;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.StoneZoneEntrySet;
import net.mehvahdjukaar.stone_zone.api.StoneZoneModule;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneType;
import net.mehvahdjukaar.stone_zone.api.set.stone.VanillaStoneTypes;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestBlock;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestItem;
import net.mehvahdjukaar.stone_zone.common_classes.CompatChestTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;

public class StoneChestModule
extends StoneZoneModule {
    public final SimpleEntrySet<StoneType, Block> chests;
    public final ItemOnlyEntrySet<StoneType, Item> parts;
    public static final PaletteStrategy customPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild((BlockType)blockType, (ResourceManager)manager, (String)"block", null, p -> {
        while (p.size() > 4) {
            p.reduceUp();
        }
    }));

    public StoneChestModule(String modId) {
        super(modId, "sc");
        ResourceKey tab = CreativeModeTabs.FUNCTIONAL_BLOCKS;
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)StoneZoneEntrySet.of(StoneType.class, "", "chest", this.getModBlock("chest_stone"), () -> VanillaStoneTypes.STONE, stoneType -> new CompatChestBlock(this::getTile, Utils.copyPropertySafe((Block)stoneType.stone))).addTile((x$0, x$1) -> new VariantChestBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.GUARDED_BY_PIGLINS, Registries.BLOCK)).addTag(Tags.Blocks.CHESTS, Registries.BLOCK)).addTag(Tags.Items.CHESTS, Registries.ITEM)).setTabKey(tab)).defaultRecipe().addCustomItem((stoneType, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).build();
        this.addEntry((EntrySet)this.chests);
        this.parts = ((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)ItemOnlyEntrySet.builder(StoneType.class, (String)"", (String)"part", (Supplier)this.getModItem("part_stone"), () -> VanillaStoneTypes.STONE, stoneType -> new Item(new Item.Properties())).addTextureM(this.modRes("item/part_stone"), StoneZone.res("item/sc/part_stone_m"), customPalette)).addModelTransform(m -> m.addModifier((s, blockId, stoneType) -> s.replace("\"stonechest:item/part_stone\"", "\"" + String.valueOf(StoneZone.res("item/" + this.shortenedId() + "/" + stoneType.getAppendableIdWith("part", ""))) + "\"")))).setTabKey(tab)).defaultRecipe().build();
        this.addEntry((EntrySet)this.parts);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTile() {
        return this.chests.getTile(CompatChestBlockEntity.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, (BlockEntityType<CompatChestBlockEntity>)this.chests.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> this.chests.blocks.forEach((stoneType, block) -> {
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), stoneType, block, this.modRes("entity/chest/stone"), StoneZone.res("entity/sc/stone_m"), StoneZone.res("entity/sc/stone_o"), null);
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), stoneType, block, this.modRes("entity/chest/stone_left"), StoneZone.res("entity/sc/stone_left_m"), StoneZone.res("entity/sc/stone_left_o"), null);
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), stoneType, block, this.modRes("entity/chest/stone_right"), StoneZone.res("entity/sc/stone_right_m"), StoneZone.res("entity/sc/stone_right_o"), null);
        }));
    }

    private class VariantChestBlockEntity
    extends CompatChestBlockEntity {
        public VariantChestBlockEntity(StoneChestModule stoneChestModule, BlockPos pos, BlockState state) {
            super(stoneChestModule.chests.getTile(), pos, state);
        }
    }
}

