/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.modules.quark;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.misc.ModelConfiguration;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.stone_zone.api.StoneZoneEntrySet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.module.IDisableable;
import org.violetmoon.zeta.module.ZetaModule;

public class QuarkEntrySet<T extends BlockType, B extends Block>
extends StoneZoneEntrySet<T, B> {
    private final Supplier<ZetaModule> zetaModule;

    public QuarkEntrySet(Class<T> type, String name, @Nullable String prefix, Class<? extends ZetaModule> module, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier, @Nullable Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, SimpleEntrySet.LootTableMode tableMode, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable SimpleEntrySet.ITileHolder<?> tileFactory, @Nullable Object renderType, @Nullable BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, boolean copyTint, Predicate<T> condition, ModelConfiguration modelConfig) {
        super(type, name, prefix, blockSupplier, baseBlock, baseType, Objects.requireNonNull(tab), tabMode, tableMode, itemFactory, tileFactory, renderType, paletteSupplier, extraTransform, mergedPalette, copyTint, condition, modelConfig);
        Class m = (Class)Preconditions.checkNotNull(module);
        this.zetaModule = Suppliers.memoize(() -> Quark.ZETA.modules.get(m));
    }

    public void generateRecipes(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        ZetaModule mod = this.zetaModule.get();
        if (mod == null || mod.enabled) {
            super.generateRecipes(module, manager, sink);
        }
    }

    @Nullable
    public Item getItemOf(T type) {
        ZetaModule mod = this.zetaModule.get();
        if (mod == null || mod.enabled) {
            IDisableable d;
            BlockItem bi;
            Block block;
            IDisableable d2;
            Item item = super.getItemOf(type);
            if (item instanceof IDisableable && !(d2 = (IDisableable)item).doesConditionApply()) {
                return null;
            }
            if (item instanceof BlockItem && (block = (bi = (BlockItem)item).getBlock()) instanceof IDisableable && !(d = (IDisableable)block).doesConditionApply()) {
                return null;
            }
            return item;
        }
        return null;
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, Class<? extends ZetaModule> quarkModule, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> factory) {
        return new Builder<T, B>(type, name, null, quarkModule, baseType, baseBlock, factory);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, String prefix, Class<? extends ZetaModule> quarkModule, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> factory) {
        return new Builder<T, B>(type, name, prefix, quarkModule, baseType, baseBlock, factory);
    }

    public static class Builder<T extends BlockType, B extends Block>
    extends StoneZoneEntrySet.Builder<T, B> {
        private final Function<T, B> blockSupplier;
        private final Class<? extends ZetaModule> quarkModule;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Class<? extends ZetaModule> quarkModule, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> factory) {
            super(type, name, prefix, baseType, baseBlock, null);
            this.quarkModule = quarkModule;
            this.blockSupplier = factory;
        }

        @Override
        public QuarkEntrySet<T, B> build() {
            QuarkEntrySet<T, B> e = new QuarkEntrySet<T, B>(this.type, this.name, this.prefix, this.quarkModule, this.baseBlock, this.baseType, this.blockSupplier, this.tab, this.tabMode, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, this.palette, this.extraModelTransform, this.useMergedPalette, this.copyTint, this.condition, this.modelConfig);
            ((QuarkEntrySet)e).recipeLocations.addAll(this.recipes);
            ((QuarkEntrySet)e).tags.putAll(this.tags);
            ((QuarkEntrySet)e).textures.addAll(this.textures);
            return e;
        }
    }
}

