/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.mehvahdjukaar.stone_zone.misc.ModelUtils;
import net.mehvahdjukaar.stone_zone.misc.ResourceUtils;
import net.mehvahdjukaar.stone_zone.misc.TintConfiguration;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneZoneEntrySet<T extends BlockType, B extends class_2248>
extends SimpleEntrySet<T, B> {
    protected TintConfiguration tintConfiguration;

    protected StoneZoneEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<B> baseBlock, Supplier<T> baseType, @NotNull Supplier<class_5321<class_1761>> tab, TabAddMode tabMode, SimpleEntrySet.LootTableMode lootMode, @Nullable TriFunction<T, B, class_1792.class_1793, class_1792> itemFactory, @Nullable SimpleEntrySet.ITileHolder tileFactory, @Nullable Object renderType, @Nullable @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable McMetaFile>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, TintConfiguration tintConfig, boolean copyTint, Predicate<T> condition) {
        super(type, name, prefix, blockSupplier, baseBlock, baseType, tab, tabMode, lootMode, itemFactory, tileFactory, renderType, paletteSupplier, extraTransform, mergedPalette, copyTint, condition);
        this.tintConfiguration = tintConfig;
    }

    public static <T extends BlockType, B extends class_2248> Builder<T, B> of(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends class_2248> Builder<T, B> of(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    protected BlockTypeResTransformer<T> makeModelTransformer(SimpleModule module, class_3300 manager) {
        String nameBaseStone = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.getModId(), (class_3300)manager).replaceWithTextureFromChild("minecraft:block/" + nameBaseStone, "stone").replaceWithTextureFromChild("minecraft:block/cobblestone", "cobblestone").replaceWithTextureFromChild("minecraft:block/" + nameBaseStone + "_bricks", "bricks").replaceWithTextureFromChild("minecraft:block/smooth_" + nameBaseStone, "smooth").replaceWithTextureFromChild("minecraft:block/polished_" + nameBaseStone, "polished").replaceWithTextureFromChild("minecraft:block/mossy_" + nameBaseStone + "_bricks", "mossy_bricks").addModifier((s, blockId, blockType) -> {
            JsonObject jsonObject = class_3518.method_15285((String)s);
            ModelUtils.addTintIndexToModelAndReplaceParent(class_2960.method_60654((String)"none"), jsonObject, module, nameBaseStone, this.tintConfiguration);
            return jsonObject.toString();
        }).andThen(super.makeModelTransformer(module, manager));
    }

    protected BlockTypeResTransformer<T> makeBlockStateTransformer(SimpleModule module, class_3300 manager) {
        String nameBaseStone = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.getModId(), (class_3300)manager).replaceWithTextureFromChild("minecraft:block/" + nameBaseStone, "stone").replaceWithTextureFromChild("minecraft:block/polished_" + nameBaseStone, "polished").addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/" + nameBaseStone, ResourceUtils.getChildModelId("stone", stoneType, blockId))).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/" + nameBaseStone + "_bricks", ResourceUtils.getChildModelId("bricks", stoneType, blockId))).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/smooth_" + nameBaseStone, ResourceUtils.getChildModelId("smooth", stoneType, blockId))).andThen(super.makeBlockStateTransformer(module, manager));
    }

    public void generateTags(SimpleModule module, DynamicDataPack pack, class_3300 manager) {
        super.generateTags(module, pack, manager);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"wardstone", (String)"architects_palette", (String)"wizard_blocks", (boolean)true, (boolean)false, (DynamicDataPack)pack);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"seared_stone", (String)"tconstruct", (String)"seared_blocks", (boolean)true, (boolean)true, (DynamicDataPack)pack);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"scorched_stone", (String)"tconstruct", (String)"scorched_blocks", (boolean)true, (boolean)true, (DynamicDataPack)pack);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"sugilite", (String)"caverns_and_chasms", (String)"static_note_blocks", (boolean)true, (boolean)true, (DynamicDataPack)pack);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"cassiterite", (String)"caverns_and_chasms", (String)"deflects_projectiles", (boolean)true, (boolean)false, (DynamicDataPack)pack);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"cassiterite", (String)"caverns_and_chasms", (String)"weaker_deflect_velocity", (boolean)true, (boolean)false, (DynamicDataPack)pack);
    }

    public static class Builder<T extends BlockType, B extends class_2248>
    extends SimpleEntrySet.Builder<T, B> {
        protected TintConfiguration tintConfig = TintConfiguration.EMPTY;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            super(type, name, prefix, baseType, baseBlock, blockFactory);
        }

        public Builder<T, B> createPaletteFromStone() {
            return (Builder)this.createPaletteFromChild("stone");
        }

        public Builder<T, B> createPaletteFromBricks() {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild("bricks") != null) {
                    return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"bricks", null, (BlockType)blockType, (class_3300)manager);
                }
                return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"stone", null, (BlockType)blockType, (class_3300)manager);
            });
            return this;
        }

        public Builder<T, B> createPaletteFromStoneChild(String childKey) {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild(childKey) != null) {
                    return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)childKey, null, (BlockType)blockType, (class_3300)manager);
                }
                return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"stone", null, (BlockType)blockType, (class_3300)manager);
            });
            return this;
        }

        public StoneZoneEntrySet<T, B> build() {
            if (this.tab == null && PlatHelper.isDev()) {
                throw new IllegalStateException("Tab for module " + this.name + " was null!");
            }
            this.copyParentTint();
            StoneZoneEntrySet e = new StoneZoneEntrySet(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.tabMode, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, this.palette, this.extraModelTransform, this.useMergedPalette, this.tintConfig, this.copyTint, this.condition);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }

        public Builder<T, B> excludeMultipleTextureFromTinting(class_2960 parentId, String ... textureKeys) {
            if (this.tintConfig == TintConfiguration.EMPTY) {
                this.tintConfig = TintConfiguration.createNew();
            }
            this.tintConfig.addParentAndTextureValues(parentId, textureKeys);
            return this;
        }

        public Builder<T, B> excludeTextureFromTinting(String ... textureKeys) {
            if (this.tintConfig == TintConfiguration.EMPTY) {
                this.tintConfig = TintConfiguration.createNew();
            }
            this.tintConfig.addTextureValues(textureKeys);
            return this;
        }
    }
}

