/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.MudType;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MudTypeRegistry
extends BlockTypeRegistry<MudType> {
    public static final MudTypeRegistry INSTANCE = new MudTypeRegistry();
    public static final MudType MUD_TYPE = new MudType(class_2960.method_60656((String)"mud"), class_2246.field_37576);

    public MudTypeRegistry() {
        super(MudType.class, "mud_type");
    }

    public static MudType getMudType() {
        return MudTypeRegistry.getValue("mud");
    }

    public static Collection<MudType> getTypes() {
        return INSTANCE.getValues();
    }

    public static MudType getValue(String mudTypeId) {
        return (MudType)INSTANCE.get(class_2960.method_60654((String)mudTypeId));
    }

    public MudType getDefaultType() {
        return MUD_TYPE;
    }

    public Optional<MudType> detectTypeFromBlock(class_2248 baseblock, class_2960 baseRes) {
        String path = baseRes.method_12832();
        if (path.matches("[a-z]+_mud_bricks") && baseblock.method_9564().method_51364() == class_2766.field_12653 && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.method_12836())) {
            String mudName = path.substring(0, path.length() - 7);
            String mudAlt = mudName + "_mud";
            class_2960 idBlockType = baseRes.method_45136(mudName);
            class_2960 idBlockTypeAlt = baseRes.method_45136(mudAlt);
            if (Objects.isNull(this.get(idBlockType)) || Objects.isNull(this.get(idBlockTypeAlt))) {
                Optional opt = class_7923.field_41175.method_17966(baseRes.method_45136(mudName));
                Optional alt = class_7923.field_41175.method_17966(baseRes.method_45136(mudAlt));
                if (opt.isPresent()) {
                    return Optional.of(new MudType(baseRes.method_45136(mudName), (class_2248)opt.get()));
                }
                if (alt.isPresent()) {
                    return Optional.of(new MudType(baseRes.method_45136(mudAlt), (class_2248)alt.get()));
                }
            }
        }
        return Optional.empty();
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(mudType -> {
            if (language.isDefault()) {
                language.addEntry(mudType.getTranslationKey(), mudType.getReadableName());
            }
        });
    }

    public int priority() {
        return 110;
    }
}

