/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.StoneType;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class StoneTypeRegistry
extends BlockTypeRegistry<StoneType> {
    public static final StoneTypeRegistry INSTANCE = new StoneTypeRegistry();
    public static final StoneType STONE_TYPE = new StoneType(class_2960.method_60656((String)"stone"), class_2246.field_10340);

    public StoneTypeRegistry() {
        super(StoneType.class, "stone_type");
        this.addFinder(StoneType.Finder.vanilla("andesite"));
        this.addFinder(StoneType.Finder.vanilla("diorite"));
        this.addFinder(StoneType.Finder.vanilla("granite"));
        this.addFinder(StoneType.Finder.vanilla("tuff"));
        this.addFinder(StoneType.Finder.vanilla("calcite"));
        this.addFinder(StoneType.Finder.vanilla("blackstone"));
    }

    public static StoneType getStoneType() {
        return StoneTypeRegistry.getValue("stone");
    }

    public static StoneType getAndesiteType() {
        return StoneTypeRegistry.getValue("andesite");
    }

    public static Collection<StoneType> getTypes() {
        return INSTANCE.getValues();
    }

    public static StoneType getValue(String stoneTypeId) {
        return (StoneType)INSTANCE.get(class_2960.method_60654((String)stoneTypeId));
    }

    public StoneType getDefaultType() {
        return STONE_TYPE;
    }

    public Optional<StoneType> detectTypeFromBlock(class_2248 baseblock, class_2960 baseRes) {
        String path = baseRes.method_12832();
        if (baseRes.method_12836().matches("tfc|afc") && path.matches("rock/bricks/\\w+") && baseblock.method_9564().method_51364() == class_2766.field_12653) {
            int index = path.lastIndexOf("/");
            String stoneName = path.substring(index + 1);
            Optional opt = class_7923.field_41175.method_17966(baseRes.method_45136(path.replace("bricks", "raw")));
            if (opt.isPresent()) {
                return Optional.of(new StoneType(baseRes.method_45136(stoneName), (class_2248)opt.get()));
            }
        }
        if (!HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.method_12836())) {
            if (path.matches("[a-z]+(?:_(?:bricks?|stairs)|_stone_(?:bricks?|stairs))") && baseblock.method_9564().method_51364() == class_2766.field_12653) {
                boolean isStoneTypeBlacklisted;
                String stoneName = path.substring(0, path.length() - 7);
                stoneAlt = stoneName + "_stone";
                idBlockType = baseRes.method_45136(stoneName);
                class_2960 idBlockTypeAlt = baseRes.method_45136(stoneAlt);
                boolean bl = isStoneTypeBlacklisted = !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.method_45136(stoneName).toString()) && !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.method_45136(stoneAlt).toString());
                if ((Objects.isNull(this.get(idBlockType)) || Objects.isNull(this.get(idBlockTypeAlt))) && isStoneTypeBlacklisted) {
                    Optional opt = class_7923.field_41175.method_17966(idBlockType);
                    Optional alt = class_7923.field_41175.method_17966(idBlockTypeAlt);
                    if (opt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.method_45136(stoneName), (class_2248)opt.get()));
                    }
                    if (alt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.method_45136(stoneAlt), (class_2248)alt.get()));
                    }
                }
            } else if (path.matches("polished_[a-z]+(?:_stone)?") && baseblock.method_9564().method_51364() == class_2766.field_12653) {
                boolean isStoneTypeBlacklisted;
                String stoneName = path.replace("polished_", "");
                stoneAlt = stoneName + "_stone";
                idBlockType = baseRes.method_45136(stoneName);
                class_2960 idBlockTypeAlt = baseRes.method_45136(stoneAlt);
                boolean bl = isStoneTypeBlacklisted = !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.method_45136(stoneName).toString()) && !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.method_45136(stoneAlt).toString());
                if ((Objects.isNull(this.get(idBlockType)) || Objects.isNull(this.get(idBlockTypeAlt))) && isStoneTypeBlacklisted) {
                    Optional opt = class_7923.field_41175.method_17966(idBlockType);
                    Optional alt = class_7923.field_41175.method_17966(idBlockTypeAlt);
                    if (opt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.method_45136(stoneName), (class_2248)opt.get()));
                    }
                    if (alt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.method_45136(stoneAlt), (class_2248)alt.get()));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(stoneType -> {
            if (language.isDefault()) {
                language.addEntry(stoneType.getTranslationKey(), stoneType.getReadableName());
            }
        });
    }

    public int priority() {
        return 110;
    }
}

