/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.common_classes;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.set.StoneType;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class CompatChestTexture {
    public static void generateChestTexture(ClientDynamicResourcesHandler handler, class_3300 manager, String shortenedID, StoneType stoneType, class_2248 block, class_2960 normalRLoc, class_2960 maskRLoc, class_2960 overlayRLoc, class_2960 trappedORLoc) {
        CompatChestTexture.generateChestTexture(handler, manager, shortenedID, stoneType, block, normalRLoc, maskRLoc, overlayRLoc, trappedORLoc, 2);
    }

    public static void generateChestTexture(ClientDynamicResourcesHandler handler, class_3300 manager, String shortenedID, StoneType stoneType, class_2248 block, class_2960 normalRLoc, class_2960 maskRLoc, class_2960 overlayRLoc, class_2960 trappedORLoc, int removeDarkest) {
        try (TextureImage normalTexture = TextureImage.open((class_3300)manager, (class_2960)normalRLoc);
             TextureImage normalMask = TextureImage.open((class_3300)manager, (class_2960)maskRLoc);
             TextureImage normalOverlay = TextureImage.open((class_3300)manager, (class_2960)overlayRLoc);){
            TextureImage trapOverlay = trappedORLoc != null ? TextureImage.open((class_3300)manager, (class_2960)trappedORLoc) : null;
            Respriter respriterNormal = Respriter.masked((TextureImage)normalTexture, (TextureImage)normalMask);
            Respriter respriterOverlay = Respriter.of((TextureImage)normalOverlay);
            String path = "entity/chest/" + shortenedID + "/" + stoneType.getAppendableId() + "_chest";
            String trapped_path = "entity/chest/" + shortenedID + "/" + stoneType.getAppendableId() + "_trapped_chest";
            if (normalRLoc.toString().contains("left")) {
                path = path + "_left";
                trapped_path = trapped_path + "_left";
            } else if (normalRLoc.toString().contains("right")) {
                path = path + "_right";
                trapped_path = trapped_path + "_right";
            }
            try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)stoneType.stone));){
                List plankPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                if (stoneType.getId().toString().equals("regions_unexplored:brimwood")) {
                    plankPalette.forEach(p -> {
                        p.reduceUp();
                        p.reduceUp();
                        p.reduceUp();
                        p.reduceUp();
                    });
                }
                McMetaFile plankMeta = plankTexture.getMcMeta();
                ArrayList<Palette> overlayPalette = new ArrayList<Palette>();
                for (Palette p2 : plankPalette) {
                    PaletteColor d1 = p2.getDarkest();
                    PaletteColor d2 = p2.getDarkest();
                    if (!stoneType.getId().toString().equals("regions_unexplored:brimwood")) {
                        switch (removeDarkest) {
                            case 2: {
                                p2.remove(d2);
                            }
                            case 1: {
                                p2.remove(d1);
                            }
                        }
                    }
                    HCLColor n1 = new HCLColor(d1.hcl().hue(), d1.hcl().chroma() * 0.75f, d1.hcl().luminance() * 0.4f, d1.hcl().alpha());
                    HCLColor n2 = new HCLColor(d2.hcl().hue(), d2.hcl().chroma() * 0.75f, d2.hcl().luminance() * 0.6f, d2.hcl().alpha());
                    Palette pal = Palette.ofColors(List.of(n1, n2));
                    overlayPalette.add(pal);
                }
                class_2960 res = StoneZone.res(path);
                if (!handler.alreadyHasTextureAtLocation(manager, res)) {
                    class_2960 trappedRes = StoneZone.res(trapped_path);
                    CompatChestTexture.createChestTextures(handler, respriterNormal, respriterOverlay, plankMeta, plankPalette, overlayPalette, res, trappedRes, trapOverlay);
                }
            }
            catch (Exception ex) {
                handler.getLogger().error("Failed to generate Chest block texture for for: {} - {}", (Object)block, (Object)ex);
            }
        }
        catch (Exception ex) {
            handler.getLogger().error("Could not generate any Chest block texture: ", (Throwable)ex);
        }
    }

    private static void createChestTextures(ClientDynamicResourcesHandler handler, Respriter respriter, Respriter respriterO, McMetaFile baseMeta, List<Palette> basePalette, List<Palette> overlayPalette, class_2960 normalRLoc, class_2960 trappedRLoc, TextureImage trappedOverlay) {
        TextureImage recoloredBase = respriter.recolorWithAnimation(basePalette, baseMeta);
        TextureImage recoloredOverlay = respriterO.recolorWithAnimation(overlayPalette, baseMeta);
        recoloredBase.applyOverlay(new TextureImage[]{recoloredOverlay});
        if (trappedOverlay != null) {
            TextureImage trapped = recoloredBase.makeCopy();
            trapped.applyOverlay(new TextureImage[]{trappedOverlay.makeCopy()});
            ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(trappedRLoc, trapped);
        }
        ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(normalRLoc, recoloredBase);
    }
}

