/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.StoneZoneModule;
import net.mehvahdjukaar.stone_zone.misc.TintConfiguration;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public final class ModelUtils {
    private static final Pattern PATH_PATTERN = Pattern.compile("(?<folder>.*?)(?<path>/.*$)");
    private static final Set<class_2960> RESOLVED_PARENTS = new HashSet<class_2960>();

    public static void reset() {
        RESOLVED_PARENTS.clear();
    }

    public static class_2960 transformModelID(class_2960 id) {
        Matcher matcher = PATH_PATTERN.matcher(id.method_12832());
        if (!matcher.find() || id.method_12836().contains("stonezone")) {
            return id;
        }
        return StoneZone.res(matcher.group("folder") + "/" + id.method_12836() + matcher.group("path"));
    }

    public static void addTintIndexToModelAndReplaceParent(class_2960 oldRes, JsonObject jsonObject, @Nullable SimpleModule module, @Nullable String ignoreIfFromStone, TintConfiguration config) {
        ModelUtils.replaceParent(jsonObject, module, ignoreIfFromStone, config);
        ModelUtils.addTintIndexToModel(oldRes, jsonObject, 0, config);
    }

    private static void replaceParent(JsonObject jsonObject, @Nullable SimpleModule module, @Nullable String ignoreIfFromStone, TintConfiguration config) {
        if (jsonObject.has("parent")) {
            class_2960 oldRes = class_2960.method_60654((String)jsonObject.get("parent").getAsString());
            String path = oldRes.method_12832();
            int idx = path.lastIndexOf("/");
            if (ignoreIfFromStone != null && idx != -1 && path.substring(idx + 1).contains(ignoreIfFromStone) && !path.contains("/parent/") && !path.contains("template")) {
                return;
            }
            if (!oldRes.toString().matches("minecraft:(?:item/generated|builtin/generated|item/chest)")) {
                class_2960 newRes = ModelUtils.transformModelID(oldRes);
                jsonObject.addProperty("parent", newRes.toString());
                if (module instanceof StoneZoneModule) {
                    StoneZoneModule stonezoneModule = (StoneZoneModule)module;
                    if (!RESOLVED_PARENTS.contains(oldRes) && !oldRes.method_12836().matches("stonezone")) {
                        stonezoneModule.markModelForModification(oldRes, config);
                        RESOLVED_PARENTS.add(oldRes);
                    }
                }
            }
        }
    }

    private static void addTintIndexToModel(class_2960 oldRes, JsonObject jsonObject, int tintIndex, TintConfiguration config) {
        JsonElement elements = jsonObject.get("elements");
        if (elements != null) {
            for (JsonElement element : elements.getAsJsonArray()) {
                JsonObject elementObject;
                JsonObject faces;
                if (!(element instanceof JsonObject) || (faces = (elementObject = (JsonObject)element).getAsJsonObject("faces")) == null) continue;
                for (String keyFaces : faces.keySet()) {
                    JsonObject face = faces.getAsJsonObject(keyFaces);
                    String textureValue = face.get("texture").getAsString();
                    if (!face.has("tintindex")) {
                        if (!config.isExcluded(textureValue) || !config.isTextureExcludedFor(oldRes, textureValue)) continue;
                        face.addProperty("tintindex", (Number)tintIndex);
                        continue;
                    }
                    if (!face.get("tintindex").getAsString().equals(String.valueOf(tintIndex)) || config.isExcluded(textureValue) && config.isTextureExcludedFor(oldRes, textureValue)) continue;
                    face.remove("tintindex");
                }
            }
        }
    }

    public static Map<class_2960, JsonObject> readAllModelsAndParents(class_3300 manager, Collection<class_2960> models) {
        HashMap<class_2960, JsonObject> jsonObjects = new HashMap<class_2960, JsonObject>();
        for (class_2960 res : models) {
            if (res.method_12836().matches("stonezone")) continue;
            ModelUtils.readJsonsRecursive(manager, res, jsonObjects);
        }
        return jsonObjects;
    }

    private static void readJsonsRecursive(class_3300 manager, class_2960 res, Map<class_2960, JsonObject> jsonObjects) {
        StaticResource resource = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.MODELS.getPath(res));
        if (resource != null) {
            JsonObject json = class_3518.method_15285((String)new String(resource.data)).getAsJsonObject();
            jsonObjects.put(res, json);
            if (json.has("parent")) {
                class_2960 parent = class_2960.method_60654((String)json.get("parent").getAsString());
                if (RESOLVED_PARENTS.contains(parent)) {
                    return;
                }
                RESOLVED_PARENTS.add(parent);
                ModelUtils.readJsonsRecursive(manager, parent, jsonObjects);
            }
        }
    }
}

