/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.misc.ModelConfiguration;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.stone_zone.misc.CompatSpritesHelper;
import net.mehvahdjukaar.stone_zone.misc.ResourcesUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneZoneEntrySet<T extends BlockType, B extends Block>
extends SimpleEntrySet<T, B> {
    protected StoneZoneEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<B> baseBlock, Supplier<T> baseType, @NotNull Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, SimpleEntrySet.LootTableMode lootMode, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable SimpleEntrySet.ITileHolder tileFactory, @Nullable Object renderType, @Nullable BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, boolean copyTint, Predicate<T> condition, ModelConfiguration modelConfig) {
        super(type, name, prefix, blockSupplier, baseBlock, baseType, tab, tabMode, lootMode, itemFactory, tileFactory, renderType, paletteSupplier, extraTransform, mergedPalette, copyTint, condition, modelConfig);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    public void generateModels(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        net.mehvahdjukaar.every_compat.misc.ResourcesUtils.generateStandardBlockModels((ResourceManager)manager, (ResourceSink)sink, (Map)this.blocks, (BlockType)((BlockType)this.baseType.get()), this.makeModelTransformer(module, manager), this.makeBlockStateTransformer(module, manager), (ModelConfiguration)this.modelConfiguration);
        net.mehvahdjukaar.every_compat.misc.ResourcesUtils.generateStandardItemModels((ResourceManager)manager, (ResourceSink)sink, (Map)this.items, (BlockType)((BlockType)this.baseType.get()), this.makeModelTransformer(module, manager), (ModelConfiguration)this.modelConfiguration);
    }

    protected BlockTypeResTransformer<T> makeModelTransformer(SimpleModule module, ResourceManager manager) {
        String oldTypeName = ((BlockType)this.baseType.get()).getTypeName();
        BlockTypeResTransformer modelTransformer = BlockTypeResTransformer.create((String)module.getModId(), (ResourceManager)manager).setIDModifier((s, blockId, blockType) -> {
            s = s.replace("stonebrick", "stone_brick");
            return BlockTypeResTransformer.replaceFullGenericType((String)s, (BlockType)blockType, (ResourceLocation)blockId, (String)oldTypeName, null, (int)2);
        }).addModifier((s, blockId, blockType) -> {
            s = BlockTypeResTransformer.replaceFullGenericType((String)s, (BlockType)blockType, (ResourceLocation)blockId, (String)oldTypeName, (String)module.getModId(), (String)"block(?!.*(?:parent|template))");
            if (CompatSpritesHelper.tintedStoneType.containsKey(blockType.getId())) {
                String stonePath = (String)CompatSpritesHelper.tintedStoneType.get(blockType.getId()).getFirst();
                String bricksPath = (String)CompatSpritesHelper.tintedStoneType.get(blockType.getId()).getSecond();
                return s.replace("minecraft:block/" + oldTypeName + "_bricks", "stonezone" + stonePath).replace("minecraft:block/" + oldTypeName, "stonezone" + bricksPath);
            }
            return s;
        });
        modelTransformer = CompatSpritesHelper.replaceStoneTextures(modelTransformer, oldTypeName);
        return modelTransformer;
    }

    protected BlockTypeResTransformer<T> makeBlockStateTransformer(SimpleModule module, ResourceManager manager) {
        String oldTypeName = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.getModId(), (ResourceManager)manager).addModifier((s, blockId, blockType) -> {
            s = s.replace("stonebrick", "stone_brick");
            BlockTypeResTransformer.replaceFullGenericType((String)s, (BlockType)blockType, (ResourceLocation)blockId, (String)oldTypeName, (String)module.getModId(), (String)"block");
            return s;
        }).replaceWithTextureFromChild("minecraft:block/" + oldTypeName, "block").replaceWithTextureFromChild("minecraft:block/polished_" + oldTypeName, "polished").addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/" + oldTypeName, ResourcesUtils.getChildModelId("block", stoneType, blockId))).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/" + oldTypeName + "_bricks", ResourcesUtils.getChildModelId("bricks", stoneType, blockId))).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/smooth_" + oldTypeName, ResourcesUtils.getChildModelId("smooth", stoneType, blockId))).replaceBlockType(oldTypeName).IDReplaceType(oldTypeName);
    }

    public void generateTags(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        super.generateTags(module, manager, sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"wardstone", (String)"architects_palette", (String)"wizard_blocks", (boolean)true, (boolean)false, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"seared_stone", (String)"tconstruct", (String)"seared_blocks", (boolean)true, (boolean)true, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"scorched_stone", (String)"tconstruct", (String)"scorched_blocks", (boolean)true, (boolean)true, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"sugilite", (String)"caverns_and_chasms", (String)"static_note_blocks", (boolean)true, (boolean)true, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"cassiterite", (String)"caverns_and_chasms", (String)"deflects_projectiles", (boolean)true, (boolean)false, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"cassiterite", (String)"caverns_and_chasms", (String)"weaker_deflect_velocity", (boolean)true, (boolean)false, (ResourceSink)sink);
    }

    public static class Builder<T extends BlockType, B extends Block>
    extends SimpleEntrySet.Builder<T, B> {
        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            super(type, name, prefix, baseType, baseBlock, blockFactory);
        }

        @Deprecated(forRemoval=true)
        public Builder<T, B> createPaletteFromStone() {
            return (Builder)this.createPaletteFromChild("stone");
        }

        @Deprecated(forRemoval=true)
        public Builder<T, B> createPaletteFromBricks() {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild("bricks") != null) {
                    PaletteStrategy.PaletteAndAnimation paletteAnimation = PaletteStrategies.makePaletteFromChild((BlockType)blockType, (ResourceManager)manager, (String)"bricks", null, p -> {});
                    return Pair.of((Object)paletteAnimation.palette(), (Object)paletteAnimation.animation());
                }
                PaletteStrategy.PaletteAndAnimation paletteAnimation = PaletteStrategies.makePaletteFromMainChild((BlockType)blockType, (ResourceManager)manager);
                return Pair.of((Object)paletteAnimation.palette(), (Object)paletteAnimation.animation());
            });
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder<T, B> createPaletteFromStoneChild(String childKey) {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild("bricks") != null) {
                    PaletteStrategy.PaletteAndAnimation paletteAnimation = PaletteStrategies.makePaletteFromChild((BlockType)blockType, (ResourceManager)manager, (String)childKey, null, p -> {});
                    return Pair.of((Object)paletteAnimation.palette(), (Object)paletteAnimation.animation());
                }
                PaletteStrategy.PaletteAndAnimation paletteAnimation = PaletteStrategies.makePaletteFromMainChild((BlockType)blockType, (ResourceManager)manager);
                return Pair.of((Object)paletteAnimation.palette(), (Object)paletteAnimation.animation());
            });
            return this;
        }

        public StoneZoneEntrySet<T, B> build() {
            if (this.tab == null && PlatHelper.isDev()) {
                throw new IllegalStateException("Tab for module " + this.name + " was null!");
            }
            StoneZoneEntrySet e = new StoneZoneEntrySet(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.tabMode, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, this.palette, this.extraModelTransform, this.useMergedPalette, this.copyTint, this.condition, this.modelConfig);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }
    }
}

