/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set;

import java.util.ArrayList;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class RockType
extends BlockType {
    public final Block block;

    protected RockType(ResourceLocation id, Block block) {
        super(id);
        this.block = block;
    }

    public String getAppendableIdWith(String prefix, String suffix) {
        Object suffixed = suffix.isEmpty() ? "" : "_" + suffix;
        Object prefixed = prefix.isEmpty() ? "" : prefix + "_";
        return this.getNamespace() + "/" + (String)prefixed + this.getTypeName() + (String)suffixed;
    }

    protected void initializeChildrenBlocks() {
        Block smooth;
        Block polished;
        this.addChild("block", this.block);
        this.addChild("stairs", this.findRelatedBlock("", "stairs"));
        this.addChild("slab", this.findRelatedBlock("", "slab"));
        this.addChild("wall", this.findRelatedBlock("", "wall"));
        this.addChild("button", this.findRelatedBlock("", "button"));
        this.addChild("pressure_plate", this.findRelatedBlock("", "pressure_plate"));
        Block cobblestone = this.findCobblestoneEntry("", "");
        if (Objects.nonNull(cobblestone)) {
            this.addChild("cobblestone", cobblestone);
            this.addChild("mossy_cobblestone", this.findRelatedBlock("mossy", ""));
        }
        if (Objects.nonNull(polished = this.findRelatedBlock("polished", ""))) {
            this.addChild("polished", polished);
            this.addChild("polished_stairs", this.findRelatedBlock("polished", "stairs"));
            this.addChild("polished_slab", this.findRelatedBlock("polished", "slab"));
            this.addChild("polished_wall", this.findRelatedBlock("polished", "wall"));
        }
        if (Objects.nonNull(smooth = this.findRelatedBlock("smooth", ""))) {
            this.addChild("smooth", smooth);
            this.addChild("smooth_stairs", this.findRelatedBlock("smooth", "stairs"));
            this.addChild("smooth_slab", this.findRelatedBlock("smooth", "slab"));
            this.addChild("smooth_wall", this.findRelatedBlock("smooth", "wall"));
        }
        Block bricks = this.findBrickEntry("", "");
        Block bricksTFC = this.findRelatedBlock("", "bricks");
        if (Objects.nonNull(bricks) || Objects.nonNull(bricksTFC)) {
            if (this.id.m_135827_().matches("tfc|afc")) {
                this.addChild("bricks", bricksTFC);
                this.addChild("brick_stairs", this.findRelatedBlock("bricks", "stairs"));
                this.addChild("brick_slab", this.findRelatedBlock("bricks", "slab"));
                this.addChild("brick_wall", this.findRelatedBlock("bricks", "wall"));
                this.addChild("cracked_bricks", this.findRelatedBlock("cracked_bricks", ""));
            } else {
                this.addChild("bricks", bricks);
                this.addChild("brick_stairs", this.findBrickEntry("", "stairs"));
                this.addChild("brick_slab", this.findBrickEntry("", "slab"));
                this.addChild("brick_wall", this.findBrickEntry("", "wall"));
                this.addChild("brick_tiles", this.findBrickEntry("", "tiles"));
                this.addChild("cracked_bricks", this.findBrickEntry("cracked", ""));
                this.addChild("mossy_bricks", this.findBrickEntry("mossy", ""));
                this.addChild("mossy_brick_slab", this.findBrickEntry("mossy", "slab"));
                this.addChild("mossy_brick_stairs", this.findBrickEntry("mossy", "stairs"));
                this.addChild("mossy_brick_wall", this.findBrickEntry("mossy", "wall"));
            }
        }
    }

    protected void initializeChildrenItems() {
    }

    @Nullable
    private Block findCobblestoneEntry(String prefix, String suffix) {
        Object suffixed = suffix.isEmpty() ? "" : "_" + suffix;
        Block first = (Block)this.findRelatedEntry("cobbled", suffix, (Registry)BuiltInRegistries.f_256975_);
        if (first != null) {
            return first;
        }
        return (Block)this.findRelatedEntry(prefix, "cobblestone" + (String)suffixed, (Registry)BuiltInRegistries.f_256975_);
    }

    @Nullable
    private Block findBrickEntry(String prefix, String suffix) {
        Object suffixed = suffix.isEmpty() ? "" : "_" + suffix;
        Block first = (Block)this.findRelatedEntry(prefix, "brick" + (String)suffixed, (Registry)BuiltInRegistries.f_256975_);
        if (first != null) {
            return first;
        }
        return (Block)this.findRelatedEntry(prefix, "bricks" + (String)suffixed, (Registry)BuiltInRegistries.f_256975_);
    }

    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, Registry<V> reg) {
        if (this.id.toString().equals("minecraft:stone") && prefixOrInfix.equals("cobblestone")) {
            return (V)reg.m_7745_(new ResourceLocation("cobblestone"));
        }
        Object prefixed = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
        Object infixed = prefixOrInfix.isEmpty() ? "" : "_" + prefixOrInfix;
        Object suffixed = suffix.isEmpty() ? "" : "_" + suffix;
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + (String)infixed + (String)suffixed), new ResourceLocation(this.id.m_135827_(), (String)prefixed + this.id.m_135815_() + (String)suffixed), new ResourceLocation(this.id.m_135827_(), "rock/raw/" + this.id.m_135815_() + (String)suffixed), new ResourceLocation(this.id.m_135827_(), "rock/" + (String)prefixed + suffix + "/" + this.id.m_135815_()), new ResourceLocation(this.id.m_135827_(), "rock/" + prefixOrInfix + "/" + this.id.m_135815_() + (String)suffixed)};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.m_7804_(r)) continue;
            found = reg.m_7745_(r);
            break;
        }
        return (V)found;
    }

    @Nullable
    private Block findRelatedBlock(String prefixOrInfix, String suffix) {
        return (Block)this.findRelatedEntry(prefixOrInfix, suffix, (Registry)BuiltInRegistries.f_256975_);
    }

    @Nullable
    private Item findRelatedItem(String prefixOrInfix, String suffix) {
        return (Item)this.findRelatedEntry(prefixOrInfix, suffix, (Registry)BuiltInRegistries.f_257033_);
    }

    public ItemLike mainChild() {
        return this.block;
    }

    public Block bricksOrStone() {
        Block bricks = this.getBlockOfThis("bricks");
        return bricks != null ? bricks : this.block;
    }

    protected static ResourceLocation[] makeKnownIDConventions(ResourceLocation id, String ... suffixKeyword) {
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        for (String keyword : suffixKeyword) {
            String path = id.m_135815_();
            String namespace = id.m_135827_();
            Object suffixed = keyword.isEmpty() ? "" : "_" + keyword;
            Object prefixed = keyword.isEmpty() ? "" : keyword + "_";
            resources.add(new ResourceLocation(namespace, path + (String)suffixed));
            resources.add(new ResourceLocation(namespace, (String)prefixed + path));
        }
        return resources.toArray(new ResourceLocation[0]);
    }
}

