/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set.stone;

import java.util.Collection;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneType;
import net.mehvahdjukaar.stone_zone.api.set.stone.VanillaStoneTypes;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class StoneTypeRegistry
extends BlockTypeRegistry<StoneType> {
    public static final StoneTypeRegistry INSTANCE = new StoneTypeRegistry();

    public StoneTypeRegistry() {
        super(StoneType.class, "stone_type");
    }

    protected StoneType register(StoneType vanillaType) {
        return (StoneType)super.register((BlockType)vanillaType);
    }

    public StoneType getDefaultType() {
        return VanillaStoneTypes.STONE;
    }

    public Optional<StoneType> detectTypeFromBlock(Block baseblock, ResourceLocation baseRes) {
        String blockPath = baseRes.m_135815_();
        if (baseRes.m_135827_().matches("tfc|afc") && blockPath.matches("rock/bricks/\\w+") && baseblock.m_49966_().m_280603_() == NoteBlockInstrument.BASEDRUM) {
            int index = blockPath.lastIndexOf("/");
            String stoneName = blockPath.substring(index + 1);
            Optional opt = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(baseRes.m_135827_(), blockPath.replace("bricks", "raw")));
            if (opt.isPresent()) {
                return Optional.of(new StoneType(baseRes.m_247449_(stoneName), (Block)opt.get()));
            }
        }
        if (!HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.m_135827_())) {
            if (blockPath.matches("[a-z]+_(?:stone_)?bricks?")) {
                boolean noWoodType;
                String stoneName = blockPath.substring(0, blockPath.length() - 7);
                stoneAlt = stoneName + "_stone";
                idBlockType = baseRes.m_247449_(stoneName);
                ResourceLocation idBlockTypeAlt = baseRes.m_247449_(stoneAlt);
                boolean isStoneTypeNotBlacklisted = !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.m_247449_(stoneName).toString()) && !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.m_247449_(stoneAlt).toString());
                boolean noDustType = !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replaceAll("(?<name>[a-z]+_)\\w+", "${name}dust")));
                boolean noOreType = !BuiltInRegistries.f_256975_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replaceAll("(?<name>[a-z]+_)\\w+", "${name}ore")));
                boolean bl = noWoodType = !BuiltInRegistries.f_256975_.m_7804_(new ResourceLocation(baseRes.m_135827_(), blockPath.replaceAll("(?<name>[a-z]+_)[a-z]+", "${name}log")));
                if (!this.valuesReg.containsKey(idBlockType) && !this.valuesReg.containsKey(idBlockTypeAlt) && isStoneTypeNotBlacklisted && noDustType && noOreType && noWoodType) {
                    Optional opt = BuiltInRegistries.f_256975_.m_6612_(idBlockType);
                    Optional alt = BuiltInRegistries.f_256975_.m_6612_(idBlockTypeAlt);
                    if (opt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.m_247449_(stoneName), (Block)opt.get()));
                    }
                    if (alt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.m_247449_(stoneAlt), (Block)alt.get()));
                    }
                }
            } else if (blockPath.matches("polished_[a-z]+(?:_stone)?")) {
                boolean isStoneTypeBlacklisted;
                String stoneName = blockPath.replace("polished_", "");
                stoneAlt = stoneName + "_stone";
                idBlockType = baseRes.m_247449_(stoneName);
                ResourceLocation idBlockTypeAlt = baseRes.m_247449_(stoneAlt);
                boolean bl = isStoneTypeBlacklisted = !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.m_247449_(stoneName).toString()) && !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.m_247449_(stoneAlt).toString());
                if (!this.valuesReg.containsKey(idBlockType) && !this.valuesReg.containsKey(idBlockTypeAlt) && isStoneTypeBlacklisted) {
                    Optional opt = BuiltInRegistries.f_256975_.m_6612_(idBlockType);
                    Optional alt = BuiltInRegistries.f_256975_.m_6612_(idBlockTypeAlt);
                    if (opt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.m_247449_(stoneName), (Block)opt.get()));
                    }
                    if (alt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.m_247449_(stoneAlt), (Block)alt.get()));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public StoneType.Finder addSimpleFinder(ResourceLocation stoneTypeId) {
        StoneType.Finder finder = new StoneType.Finder(stoneTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public StoneType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new ResourceLocation(typeId));
    }

    public StoneType.Finder addSimpleFinder(String namespace, String nameStoneType) {
        return this.addSimpleFinder(new ResourceLocation(namespace, nameStoneType));
    }

    public int priority() {
        return 110;
    }

    @Deprecated(forRemoval=true)
    public static StoneType getStoneType() {
        return StoneTypeRegistry.getValue("stone");
    }

    @Deprecated(forRemoval=true)
    public static StoneType getAndesiteType() {
        return StoneTypeRegistry.getValue("andesite");
    }

    @Deprecated(forRemoval=true)
    public static StoneType getValue(String stoneTypeId) {
        return (StoneType)INSTANCE.get(new ResourceLocation(stoneTypeId));
    }

    @Deprecated(forRemoval=true)
    public static Collection<StoneType> getTypes() {
        return INSTANCE.getValues();
    }
}

