/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.customfov;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.OptionEnum;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.FogType;

public class CustomFovMod {
    private static final OptionInstance<Double> SUBMERGED = CustomFovMod.createFovOption("submergedFovEffectScale");
    private static final OptionInstance<Double> FLYING = CustomFovMod.createFovOption("flyingFovEffectScale");
    private static final OptionInstance<Double> SPRINTING = CustomFovMod.createFovOption("sprintingFovEffectScale");
    private static final OptionInstance<Double> SPEED = CustomFovMod.createFovOption("speedFovEffectScale");
    private static final OptionInstance<Double> AIMING = CustomFovMod.createFovOption("aimingFovEffectScale");
    private static final OptionInstance<FovEffectsMode> FOV_EFFECTS_MODE = new OptionInstance("customfov.options.fovEffectsMode", fovEffectsMode -> {
        Tooltip tooltip1 = Tooltip.create((Component)Component.translatable((String)"customfov.options.fovEffectsMode.none.tooltip"));
        Tooltip tooltip2 = Tooltip.create((Component)Component.translatable((String)"customfov.options.fovEffectsMode.vanillaOnly.tooltip"));
        Tooltip tooltip3 = Tooltip.create((Component)Component.translatable((String)"customfov.options.fovEffectsMode.moddedOnly.tooltip"));
        Tooltip tooltip4 = Tooltip.create((Component)Component.translatable((String)"customfov.options.fovEffectsMode.all.tooltip"));
        return switch (fovEffectsMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> tooltip1;
            case 1 -> tooltip2;
            case 2 -> tooltip3;
            case 3 -> tooltip4;
        };
    }, OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(FovEffectsMode.values()), Codec.INT.xmap(FovEffectsMode::byId, FovEffectsMode::getId)), (Object)FovEffectsMode.ALL, val -> {});
    private static Float fovModifier;

    private static OptionInstance<Double> createFovOption(String keyIn) {
        String key = "customfov.options." + keyIn;
        return new OptionInstance(key, OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)(key + ".tooltip"))), (component, val) -> val == 0.0 ? Component.translatable((String)"options.generic_value", (Object[])new Object[]{component, CommonComponents.OPTION_OFF}) : Component.translatable((String)"options.percent_value", (Object[])new Object[]{component, (int)(val * 100.0)}), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(Mth::square, Math::sqrt), Codec.doubleRange((double)0.0, (double)1.0), (Object)1.0, val -> {});
    }

    public static Map<String, OptionInstance<?>> getOptions() {
        LinkedHashMap result = new LinkedHashMap();
        result.put("fovEffectsMode", FOV_EFFECTS_MODE);
        result.put("speedFovEffectScale", SPEED);
        result.put("sprintingFovEffectScale", SPRINTING);
        result.put("aimingFovEffectScale", AIMING);
        result.put("flyingFovEffectScale", FLYING);
        result.put("submergedFovEffectScale", SUBMERGED);
        return result;
    }

    public static OptionInstance<?>[] getList() {
        return CustomFovMod.getOptions().values().toArray(new OptionInstance[0]);
    }

    private static boolean isScoping() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        return player != null && mc.options.getCameraType().isFirstPerson() && player.isScoping();
    }

    public static float preComputeFovModifier(float currentFovModifier, boolean scale) {
        FovEffectsMode mode = (FovEffectsMode)((Object)FOV_EFFECTS_MODE.get());
        float result = 1.0f;
        if (mode == FovEffectsMode.VANILLA_ONLY || mode == FovEffectsMode.ALL) {
            fovModifier = Float.valueOf(CustomFovMod.getCustomFovModifier(currentFovModifier));
            if (scale) {
                fovModifier = Float.valueOf((float)Mth.lerp((double)((Double)Minecraft.getInstance().options.fovEffectScale().get()), (double)1.0, (double)fovModifier.floatValue()));
            }
            result = fovModifier.floatValue();
        }
        return result;
    }

    public static float postComputeFovModifier(float currentFovModifier, boolean scale) {
        float result;
        float f = result = FOV_EFFECTS_MODE.get() == FovEffectsMode.VANILLA_ONLY ? fovModifier.floatValue() : currentFovModifier;
        if (scale) {
            result = (float)Mth.lerp((double)((Double)Minecraft.getInstance().options.fovEffectScale().get()), (double)1.0, (double)result);
        }
        return result;
    }

    public static Optional<Float> computeFov(Camera camera, float currentFov) {
        FogType fogType = camera.getFluidInCamera();
        if (fogType != FogType.LAVA && fogType != FogType.WATER) {
            return Optional.empty();
        }
        FovEffectsMode mode = (FovEffectsMode)((Object)FOV_EFFECTS_MODE.get());
        float originalModifier = (float)Mth.lerp((double)((Double)Minecraft.getInstance().options.fovEffectScale().get()), (double)1.0, (double)0.8571428656578064);
        float originalFOV = currentFov / originalModifier;
        if (mode == FovEffectsMode.NONE || mode == FovEffectsMode.MODDED_ONLY) {
            return Optional.of(Float.valueOf(originalFOV));
        }
        return Optional.of(Float.valueOf(originalFOV * (1.0f - (1.0f - originalModifier) * ((Double)SUBMERGED.get()).floatValue())));
    }

    public static float getCustomFovModifier(float currentFovModifier) {
        float walkingSpeed;
        float value;
        AttributeInstance attribute;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return currentFovModifier;
        }
        float modifier = 1.0f;
        if (player.getAbilities().flying) {
            modifier *= (float)(1.0 + (double)0.1f * (Double)FLYING.get());
        }
        if ((attribute = player.getAttribute(Attributes.MOVEMENT_SPEED)) != null && (value = (float)attribute.getValue()) != (walkingSpeed = player.getAbilities().getWalkingSpeed())) {
            double speedModifier = (Double)SPEED.get();
            if (player.isSprinting()) {
                float effects = value / 1.3000001f - walkingSpeed;
                float sprint = 0.3f;
                sprint = (float)((double)sprint * (Double)SPRINTING.get());
                double modified = (walkingSpeed + (effects *= (float)speedModifier)) * (1.0f + sprint);
                modifier = (float)((double)modifier * (modified / (double)walkingSpeed + 1.0) / 2.0);
            } else {
                float effects = (float)((double)(value - walkingSpeed) * speedModifier);
                modifier = (float)((double)modifier * (double)((effects + walkingSpeed) / walkingSpeed + 1.0f) / 2.0);
            }
        }
        if (player.getAbilities().getWalkingSpeed() == 0.0f || Float.isNaN(modifier) || Float.isInfinite(modifier)) {
            modifier = 1.0f;
        }
        ItemStack itemstack = player.getUseItem();
        if (player.isUsingItem()) {
            if (itemstack.is(Items.BOW)) {
                int i = player.getTicksUsingItem();
                float f1 = (float)i / 20.0f;
                f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
                modifier *= (float)(1.0 - (double)(f1 * 0.15f) * (Double)AIMING.get());
            } else if (CustomFovMod.isScoping()) {
                modifier *= 0.1f;
            }
        }
        return modifier;
    }

    public static enum FovEffectsMode implements OptionEnum
    {
        NONE(0, "customfov.options.fovEffectsMode.none"),
        VANILLA_ONLY(1, "customfov.options.fovEffectsMode.vanillaOnly"),
        MODDED_ONLY(2, "customfov.options.fovEffectsMode.moddedOnly"),
        ALL(3, "customfov.options.fovEffectsMode.all");

        private static final FovEffectsMode[] BY_ID;
        private final int id;
        private final String key;

        private FovEffectsMode(int id, String key) {
            this.id = id;
            this.key = key;
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }

        public static FovEffectsMode byId(int id) {
            return BY_ID[Mth.positiveModulo((int)id, (int)BY_ID.length)];
        }

        static {
            BY_ID = (FovEffectsMode[])Arrays.stream(FovEffectsMode.values()).sorted(Comparator.comparingInt(FovEffectsMode::getId)).toArray(FovEffectsMode[]::new);
        }
    }
}

