/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.customfov;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.illusivesoulworks.customfov.CustomFovConstants;
import com.illusivesoulworks.customfov.CustomFovMod;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CustomFovProfiles {
    private static final Map<Integer, Map<String, Object>> PROFILES = new HashMap<Integer, Map<String, Object>>();
    private static int activeProfile = 1;
    private static KeyMapping toggleKey;
    private static KeyMapping.Category category;
    private static int cooldown;
    private static boolean passedInitialRead;

    public static KeyMapping registerKeys() {
        category = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"customfov", (String)"general"));
        toggleKey = new KeyMapping("key.customfov.profile.desc", InputConstants.UNKNOWN.getValue(), category);
        return toggleKey;
    }

    public static void tick() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.level != null && cooldown <= 0 && toggleKey.isDown()) {
            cooldown = 20;
            LocalPlayer player = mc.player;
            LinkedHashMap currentSettings = new LinkedHashMap();
            Map<String, OptionInstance<?>> options = CustomFovMod.getOptions();
            options.put("fov", Minecraft.getInstance().options.fov());
            options.forEach((key, option) -> currentSettings.put(key, option.get()));
            PROFILES.put(activeProfile, currentSettings);
            if (activeProfile == 1) {
                activeProfile = 2;
            } else if (activeProfile == 2) {
                activeProfile = 1;
            }
            Map<String, Object> map = PROFILES.get(activeProfile);
            if (map != null) {
                map.forEach((key, value) -> {
                    if (key.equals("fov")) {
                        Minecraft.getInstance().options.fov().set((Object)((Integer)value));
                    } else {
                        ((OptionInstance)options.get(key)).set(value);
                    }
                });
                player.displayClientMessage((Component)Component.translatable((String)"key.customfov.profile.switch", (Object[])new Object[]{activeProfile}), true);
            } else {
                CustomFovConstants.LOG.error("Attempted to switch to missing profile {}", (Object)activeProfile);
            }
        }
        if (cooldown > 0) {
            --cooldown;
        }
    }

    private static void initProfiles(Map<String, OptionInstance<?>> options) {
        options.forEach((key, option) -> {
            PROFILES.computeIfAbsent(1, k -> new LinkedHashMap()).put(key, option.get());
            Object def = switch (key) {
                case "fov" -> Integer.valueOf(70);
                case "fovEffectsMode" -> CustomFovMod.FovEffectsMode.ALL;
                default -> Double.valueOf(1.0);
            };
            PROFILES.computeIfAbsent(2, k -> new LinkedHashMap()).put(key, def);
        });
    }

    public static void setupProfiles() {
        File file = new File(Minecraft.getInstance().gameDirectory, "customfov.txt");
        Map<String, OptionInstance<?>> options = CustomFovMod.getOptions();
        options.put("fov", Minecraft.getInstance().options.fov());
        int profile = 1;
        passedInitialRead = true;
        if (!file.exists()) {
            CustomFovProfiles.initProfiles(options);
            return;
        }
        LinkedHashMap<Integer, Map> read = new LinkedHashMap<Integer, Map>();
        try (BufferedReader bufferedreader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            bufferedreader.lines().forEach(line -> {
                try {
                    String[] split = line.split(":");
                    read.computeIfAbsent(Integer.parseInt(split[0]), k -> new LinkedHashMap()).put(split[1], split[2]);
                }
                catch (Exception exception1) {
                    CustomFovConstants.LOG.warn("Skipping malformed profile: {}", line);
                }
            });
        }
        catch (IOException e) {
            CustomFovConstants.LOG.error("Could not read {}", (Object)file, (Object)e);
        }
        Map profileMap = read.getOrDefault(0, new HashMap());
        try {
            profile = Integer.parseInt(profileMap.getOrDefault("profile", "1"));
        }
        catch (NumberFormatException e) {
            CustomFovConstants.LOG.error("{} is not a valid profile", profileMap.get("profile"));
        }
        read.forEach((prof, map) -> map.forEach((key, value) -> {
            Map prof1 = PROFILES.computeIfAbsent((Integer)prof, k -> new LinkedHashMap());
            try {
                if (key.equals("fov")) {
                    prof1.put(key, Integer.parseInt(value));
                } else if (key.equals("fovEffectsMode")) {
                    prof1.put(key, CustomFovMod.FovEffectsMode.valueOf(value));
                } else {
                    prof1.put(key, Double.parseDouble(value));
                }
            }
            catch (Exception e) {
                CustomFovConstants.LOG.warn("Skipping malformed value {} for {}", value, key);
            }
        }));
        activeProfile = profile;
    }

    public static void saveProfiles() {
        if (!passedInitialRead) {
            return;
        }
        File file = new File(Minecraft.getInstance().gameDirectory, "customfov.txt");
        try (PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            printwriter.println("0:profile:" + activeProfile);
            PROFILES.forEach((profile, map) -> {
                if (profile == 0) {
                    return;
                }
                map.forEach((key, value) -> printwriter.println(profile + ":" + key + ":" + String.valueOf(value)));
            });
        }
        catch (Exception e) {
            CustomFovConstants.LOG.error("Failed to save profiles", (Throwable)e);
        }
    }

    static {
        cooldown = 0;
        passedInitialRead = false;
    }
}

