/*
 * Decompiled with CFR 0.152.
 */
package com.lankaster.pyrellium.world;

import com.google.gson.JsonElement;
import com.lankaster.pyrellium.config.ConfigCodec;
import com.lankaster.pyrellium.config.ConfigHandler;
import com.lankaster.pyrellium.world.ModBiomes;
import com.lankaster.pyrellium.world.tree.BurningTrunkPlacer;
import com.lankaster.pyrellium.world.tree.WillowFoliagePlacer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_7924;

public class ModWorldGeneration {
    private static final List<Pair<class_2960, JsonElement>> BIOMES_NOISE = new ArrayList<Pair<class_2960, JsonElement>>();

    public static void add(class_2960 biome, JsonElement noise) {
        BIOMES_NOISE.add((Pair<class_2960, JsonElement>)new Pair((Object)biome, (Object)noise));
    }

    public static List<Pair<class_2960, JsonElement>> getNoiseBiomes() {
        return BIOMES_NOISE;
    }

    private static void generateFeatures() {
        if (ConfigHandler.getConfig().globalFeatureConfig().doThickCeiling()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13171, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"thick_bedrock_ceiling")));
            BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13171, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"bedrock_gradient")));
        }
        if (ConfigHandler.getConfig().globalFeatureConfig().doOpalGeodes()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13171, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"opal_geode")));
        }
        if (ConfigHandler.getConfig().globalFeatureConfig().doCoolLavaLake()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_22076}), (class_2893.class_2895)class_2893.class_2895.field_13171, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"cool_lava_lake")));
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.GHOSTLY_WOODS}), (class_2893.class_2895)class_2893.class_2895.field_13171, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"cool_lava_lake")));
        }
        if (ConfigHandler.getConfig().globalFeatureConfig().doBones()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_22076}), (class_2893.class_2895)class_2893.class_2895.field_13177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"bones")));
        }
        if (ConfigHandler.getConfig().globalFeatureConfig().doFallenLogs()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_22077}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"crimson_stems")));
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_22075}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"warped_stems")));
        }
        if (ConfigHandler.getConfig().biomeConfig().mushroomWastesConfig().doSpores()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.MUSHROOM_WASTES}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"spores")));
        }
        if (ConfigHandler.getConfig().biomeConfig().mushroomWastesConfig().doWallMushrooms()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.MUSHROOM_WASTES}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"wall_mushrooms")));
        }
        if (ConfigHandler.getConfig().biomeConfig().monolithPlainsConfig().doBombFlowers()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.MONOLITH_PLAINS}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"bomb_plants")));
        }
        if (ConfigHandler.getConfig().biomeConfig().monolithPlainsConfig().doMonolith()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.MONOLITH_PLAINS}), (class_2893.class_2895)class_2893.class_2895.field_13171, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"obsidian_monolith")));
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.MONOLITH_PLAINS}), (class_2893.class_2895)class_2893.class_2895.field_13177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"monolith_floor")));
        }
        if (ConfigHandler.getConfig().globalFeatureConfig().doGildedBlackstone()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.BLACKSTONE_SPRINGS}), (class_2893.class_2895)class_2893.class_2895.field_13177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"gilded_patch")));
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.BURNING_GROVE}), (class_2893.class_2895)class_2893.class_2895.field_13177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"gilded_patch")));
        }
        if (ConfigHandler.getConfig().biomeConfig().blackstoneSpringsConfig().doBlackstoneRocks()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.BLACKSTONE_SPRINGS}), (class_2893.class_2895)class_2893.class_2895.field_13177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"blackstone_rock_patch")));
        }
        if (ConfigHandler.getConfig().biomeConfig().crystalForestConfig().doFloorCrystals()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.CRYSTAL_FOREST}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"crystal_vegetation")));
        }
        if (ConfigHandler.getConfig().biomeConfig().infestedValleyConfig().doFloorSilk()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.INFESTED_VALLEY}), (class_2893.class_2895)class_2893.class_2895.field_13177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"cobwebs")));
        }
        if (ConfigHandler.getConfig().biomeConfig().infestedValleyConfig().doHangingSilk()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.INFESTED_VALLEY}), (class_2893.class_2895)class_2893.class_2895.field_13177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"hanging_silk")));
        }
        if (ConfigHandler.getConfig().biomeConfig().quartzCavernsConfig().doSpikes()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.QUARTZ_CAVERNS}), (class_2893.class_2895)class_2893.class_2895.field_13171, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"spike")));
        }
        if (ConfigHandler.getConfig().biomeConfig().burningGroveConfig().doPyrolily()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.BURNING_GROVE}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"pyrolily_patch")));
        }
        if (ConfigHandler.getConfig().biomeConfig().ghostlyWoodsConfig().doHeadstones()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomes.GHOSTLY_WOODS}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"headstones")));
        }
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9461}), (class_2893.class_2895)class_2893.class_2895.field_13177, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"pyrellium", (String)"quartz_crystals_rare")));
    }

    private static void generateBiomes() {
        ConfigCodec.BiomeNoiseConfig biomeNoise;
        if (ConfigHandler.getConfig().biomeConfig().blackstoneSpringsConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().blackstoneSpringsConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.BLACKSTONE_SPRINGS.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.BLACKSTONE_SPRINGS, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
        if (ConfigHandler.getConfig().biomeConfig().burningGroveConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().burningGroveConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.BURNING_GROVE.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.BURNING_GROVE, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
        if (ConfigHandler.getConfig().biomeConfig().crystalForestConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().crystalForestConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.CRYSTAL_FOREST.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.CRYSTAL_FOREST, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
        if (ConfigHandler.getConfig().biomeConfig().frostburnValleyConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().frostburnValleyConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.FROSTBURN_VALLEY.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.FROSTBURN_VALLEY, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
        if (ConfigHandler.getConfig().biomeConfig().ghostlyWoodsConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().ghostlyWoodsConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.GHOSTLY_WOODS.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.GHOSTLY_WOODS, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
        if (ConfigHandler.getConfig().biomeConfig().infestedValleyConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().infestedValleyConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.INFESTED_VALLEY.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.INFESTED_VALLEY, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
        if (ConfigHandler.getConfig().biomeConfig().monolithPlainsConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().monolithPlainsConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.MONOLITH_PLAINS.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.MONOLITH_PLAINS, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
        if (ConfigHandler.getConfig().biomeConfig().mushroomWastesConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().mushroomWastesConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.MUSHROOM_WASTES.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.MUSHROOM_WASTES, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
        if (ConfigHandler.getConfig().biomeConfig().quartzCavernsConfig().enabled()) {
            biomeNoise = ConfigHandler.getConfig().biomeConfig().quartzCavernsConfig().biomeNoiseConfig();
            ModWorldGeneration.add(ModBiomes.QUARTZ_CAVERNS.method_29177(), ConfigHandler.noiseToJson(biomeNoise));
            NetherBiomes.addNetherBiome(ModBiomes.QUARTZ_CAVERNS, (class_6544.class_4762)class_6544.method_38117((float)biomeNoise.temperature(), (float)biomeNoise.humidity(), (float)biomeNoise.continentalness(), (float)biomeNoise.erosion(), (float)biomeNoise.depth(), (float)biomeNoise.weirdness(), (float)biomeNoise.offset()));
        }
    }

    public static void register() {
        ModWorldGeneration.generateFeatures();
        ModWorldGeneration.generateBiomes();
        BurningTrunkPlacer.registerBurningTrunkPlacer();
        WillowFoliagePlacer.registerWillowFoliagePlacer();
    }
}

