/*
 * Decompiled with CFR 0.152.
 */
package com.lankaster.pyrellium.world.feature;

import com.lankaster.pyrellium.world.feature.PillarFeatureConfig;
import com.lankaster.pyrellium.world.feature.PillarHelper;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;
import org.jetbrains.annotations.Nullable;

public class PillarFeature
extends class_3031<PillarFeatureConfig> {
    public PillarFeature(Codec<PillarFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<PillarFeatureConfig> context) {
        Object t;
        class_5281 structureWorldAccess = context.method_33652();
        class_2338 blockPos = context.method_33655();
        PillarFeatureConfig pillarFeatureConfig = (PillarFeatureConfig)context.method_33656();
        class_5819 random = context.method_33654();
        class_4651 state = pillarFeatureConfig.toPlace();
        class_2680 blockState = state.method_23455(random, blockPos);
        if (!PillarHelper.canGenerate((class_1936)structureWorldAccess, blockPos)) {
            return false;
        }
        Optional optional = class_5721.method_32982((class_3746)structureWorldAccess, (class_2338)blockPos, (int)pillarFeatureConfig.floorToCeilingSearchRange(), PillarHelper::canGenerate, PillarHelper::canReplaceOrLava);
        if (optional.isPresent() && (t = optional.get()) instanceof class_5721.class_5723) {
            class_5721.class_5723 bounded = (class_5721.class_5723)t;
            if (bounded.method_32992() < 4) {
                return false;
            }
            int i = (int)((float)bounded.method_32992() * pillarFeatureConfig.maxColumnRadiusToCaveHeightRatio());
            int j = class_3532.method_15340((int)i, (int)pillarFeatureConfig.columnRadius().method_35009(), (int)pillarFeatureConfig.columnRadius().method_35011());
            int k = class_3532.method_32751((class_5819)random, (int)pillarFeatureConfig.columnRadius().method_35009(), (int)j);
            DripstoneGenerator dripstoneGenerator = PillarFeature.createGenerator(blockPos.method_33096(bounded.method_32990() - 1), false, random, k, pillarFeatureConfig.stalactiteBluntness(), pillarFeatureConfig.heightScale(), blockState);
            DripstoneGenerator dripstoneGenerator2 = PillarFeature.createGenerator(blockPos.method_33096(bounded.method_32991() + 1), true, random, k, pillarFeatureConfig.stalagmiteBluntness(), pillarFeatureConfig.heightScale(), blockState);
            WindModifier windModifier = dripstoneGenerator.generateWind(pillarFeatureConfig) && dripstoneGenerator2.generateWind(pillarFeatureConfig) ? new WindModifier(blockPos.method_10264(), random, pillarFeatureConfig.windSpeed()) : WindModifier.create();
            boolean bl = dripstoneGenerator.canGenerate(structureWorldAccess, windModifier);
            boolean bl2 = dripstoneGenerator2.canGenerate(structureWorldAccess, windModifier);
            if (bl) {
                dripstoneGenerator.generate(structureWorldAccess, random, windModifier);
            }
            if (bl2) {
                dripstoneGenerator2.generate(structureWorldAccess, random, windModifier);
            }
            return true;
        }
        return false;
    }

    private static DripstoneGenerator createGenerator(class_2338 pos, boolean isStalagmite, class_5819 random, int scale, class_5863 bluntness, class_5863 heightScale, class_2680 toPlace) {
        return new DripstoneGenerator(pos, isStalagmite, scale, bluntness.method_33920(random), heightScale.method_33920(random), toPlace);
    }

    static final class DripstoneGenerator {
        private class_2338 pos;
        private final boolean isStalagmite;
        private int scale;
        private final double bluntness;
        private final double heightScale;
        private final class_2680 toPlace;

        DripstoneGenerator(class_2338 pos, boolean isStalagmite, int scale, double bluntness, double heightScale, class_2680 toPlace) {
            this.pos = pos;
            this.isStalagmite = isStalagmite;
            this.scale = scale;
            this.bluntness = bluntness;
            this.heightScale = heightScale;
            this.toPlace = toPlace;
        }

        private int getBaseScale() {
            return this.scale(0.0f);
        }

        boolean canGenerate(class_5281 world, WindModifier wind) {
            while (this.scale > 1) {
                class_2338.class_2339 mutable = this.pos.method_25503();
                int i = Math.min(10, this.getBaseScale());
                for (int j = 0; j < i; ++j) {
                    if (world.method_8320((class_2338)mutable).method_27852(class_2246.field_10164)) {
                        return false;
                    }
                    if (PillarHelper.canGenerateBase(world, wind.modify((class_2338)mutable), this.scale)) {
                        this.pos = mutable;
                        return true;
                    }
                    mutable.method_10098(this.isStalagmite ? class_2350.field_11033 : class_2350.field_11036);
                }
                this.scale /= 2;
            }
            return false;
        }

        private int scale(float height) {
            return (int)PillarHelper.scaleHeightFromRadius(height, this.scale, this.heightScale, this.bluntness);
        }

        void generate(class_5281 world, class_5819 random, WindModifier wind) {
            for (int i = -this.scale; i <= this.scale; ++i) {
                block1: for (int j = -this.scale; j <= this.scale; ++j) {
                    int k;
                    float f = class_3532.method_15355((float)(i * i + j * j));
                    if (f > (float)this.scale || (k = this.scale(f)) <= 0) continue;
                    if ((double)random.method_43057() < 0.2) {
                        k = (int)((float)k * class_3532.method_32750((class_5819)random, (float)0.8f, (float)1.0f));
                    }
                    class_2338.class_2339 mutable = this.pos.method_10069(i, 0, j).method_25503();
                    boolean bl = false;
                    int l = this.isStalagmite ? world.method_8624(class_2902.class_2903.field_13194, mutable.method_10263(), mutable.method_10260()) : Integer.MAX_VALUE;
                    for (int m = 0; m < k && mutable.method_10264() < l; ++m) {
                        class_2338 blockPos = wind.modify((class_2338)mutable);
                        if (PillarHelper.canGenerateOrLava((class_1936)world, blockPos)) {
                            bl = true;
                            world.method_8652(blockPos, this.toPlace, 2);
                        } else if (bl && !world.method_8320(blockPos).method_26215()) continue block1;
                        mutable.method_10098(this.isStalagmite ? class_2350.field_11036 : class_2350.field_11033);
                    }
                }
            }
        }

        boolean generateWind(PillarFeatureConfig config) {
            return this.scale >= config.minRadiusForWind() && this.bluntness >= (double)config.minBluntnessForWind();
        }
    }

    static final class WindModifier {
        private final int y;
        @Nullable
        private final class_243 wind;

        WindModifier(int y, class_5819 random, class_5863 wind) {
            this.y = y;
            float f = wind.method_33920(random);
            float g = class_3532.method_32750((class_5819)random, (float)0.0f, (float)((float)Math.PI));
            this.wind = new class_243((double)(class_3532.method_15362((float)g) * f), 0.0, (double)(class_3532.method_15374((float)g) * f));
        }

        private WindModifier() {
            this.y = 0;
            this.wind = null;
        }

        static WindModifier create() {
            return new WindModifier();
        }

        class_2338 modify(class_2338 pos) {
            if (this.wind == null) {
                return pos;
            }
            int i = this.y - pos.method_10264();
            class_243 vec3d = this.wind.method_1021((double)i);
            return pos.method_10069(class_3532.method_15357((double)vec3d.field_1352), 0, class_3532.method_15357((double)vec3d.field_1350));
        }
    }
}

