/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.uniwrench.api;

import java.util.ArrayList;
import java.util.HashMap;
import net.danygames2014.uniwrench.UniWrench;
import net.danygames2014.uniwrench.api.WrenchFunction;
import net.minecraft.class_17;

public class WrenchableBlockRegistry {
    public final HashMap<class_17, ArrayList<WrenchFunction>> leftClickActions = new HashMap();
    public final HashMap<class_17, ArrayList<WrenchFunction>> rightClickActions = new HashMap();
    private static WrenchableBlockRegistry INSTANCE;

    private static WrenchableBlockRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WrenchableBlockRegistry();
        }
        return INSTANCE;
    }

    public static void registerLeftClickAction(class_17 block, WrenchFunction wrenchable) {
        WrenchableBlockRegistry registry = WrenchableBlockRegistry.getInstance();
        if (!registry.leftClickActions.containsKey(block)) {
            registry.leftClickActions.put(block, new ArrayList());
        }
        UniWrench.LOGGER.info("Registering Left Click Action for block {}", (Object)block);
        WrenchableBlockRegistry.getInstance().leftClickActions.get(block).add(wrenchable);
    }

    public static void registerRightClickAction(class_17 block, WrenchFunction wrenchable) {
        WrenchableBlockRegistry registry = WrenchableBlockRegistry.getInstance();
        if (!registry.rightClickActions.containsKey(block)) {
            registry.rightClickActions.put(block, new ArrayList());
        }
        UniWrench.LOGGER.info("Registering Right Click Action for block {}", (Object)block);
        WrenchableBlockRegistry.getInstance().rightClickActions.get(block).add(wrenchable);
    }

    public static ArrayList<WrenchFunction> getLeftClickActions(class_17 block) {
        return WrenchableBlockRegistry.getInstance().leftClickActions.getOrDefault(block, new ArrayList());
    }

    public static ArrayList<WrenchFunction> getRightClickActions(class_17 block) {
        return WrenchableBlockRegistry.getInstance().rightClickActions.getOrDefault(block, new ArrayList());
    }

    public static boolean doRightClickActionsExist(class_17 block) {
        return WrenchableBlockRegistry.getInstance().rightClickActions.containsKey(block);
    }

    public static boolean doLeftClickActionsExist(class_17 block) {
        return WrenchableBlockRegistry.getInstance().leftClickActions.containsKey(block);
    }
}

