/*
 * Decompiled with CFR 0.152.
 */
package net.kriperinq.cnpccontentback.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.kriperinq.cnpccontentback.CnpcContentbackMod;
import net.kriperinq.cnpccontentback.script.Back;
import net.kriperinq.cnpccontentback.script.Blocks;
import net.kriperinq.cnpccontentback.script.Mellohi;
import net.kriperinq.cnpccontentback.script.Otherside;
import net.kriperinq.cnpccontentback.script.Pigstep;
import net.kriperinq.cnpccontentback.script.Record13;
import net.kriperinq.cnpccontentback.script.RecordEnd;
import net.kriperinq.cnpccontentback.script.Stopsound;
import net.kriperinq.cnpccontentback.world.inventory.MusicMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MusicButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MusicButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MusicButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MusicButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MusicButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MusicButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MusicMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Back.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            Pigstep.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            Record13.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            Otherside.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            Mellohi.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            Blocks.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            RecordEnd.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            Stopsound.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CnpcContentbackMod.addNetworkMessage(MusicButtonMessage.class, MusicButtonMessage::buffer, MusicButtonMessage::new, MusicButtonMessage::handler);
    }
}

