/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.cme_suck_my_duck;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.hexagram2021.cme_suck_my_duck.Type;
import com.hexagram2021.cme_suck_my_duck.transformers.InjectLogTransformer;
import com.hexagram2021.cme_suck_my_duck.transformers.InjectTraceIdUpdaterTransformer;
import com.hexagram2021.cme_suck_my_duck.transformers.Phase;
import com.hexagram2021.cme_suck_my_duck.transformers.WrapContainerTransformer;
import com.hexagram2021.cme_suck_my_duck.transformers.WrapLocalContainerTransformer;
import com.hexagram2021.cme_suck_my_duck.utils.Log;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import javax.annotation.Nullable;

public class CMESuckMyDuck {
    public static final Gson GSON = new Gson();
    public static final Log logger = new Log("CMESuckMyDuck", StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
    public static final int ASM_API_VERSION;
    public static final boolean INJECT_METHOD;
    @Nullable
    public static final Integer LOCAL_VAR_INDEX;
    public static final Integer MATCH_LOCAL_INDEX;
    @Nullable
    public static final String TRACE_ID_UPDATER;

    public static void main(String[] args) {
        if (args.length == 3) {
            try {
                String[] stringArray;
                ClassFileTransformer transformer;
                FileInputStream is = new FileInputStream(args[0]);
                FileOutputStream os = new FileOutputStream(args[1]);
                byte[] bytes = new byte[is.available()];
                if (is.read(bytes) != -1 && (transformer = CMESuckMyDuck.getTransformer(stringArray = args[2].split(";"))) != null) {
                    os.write(transformer.transform(null, args[0].replace(".", "/"), null, null, bytes));
                    os.close();
                    is.close();
                    return;
                }
                os.close();
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("This project can only be used as javaagent.");
        System.out.println("Usage:");
        System.out.println("\t-javaagent:CMESuckMyDuck-<version>.jar=<class full name>;<field name>;<type>;<phase>");
        System.out.println("For example:");
        System.out.println("\t-javaagent:mods/CMESuckMyDuck-1.1.0.jar=net/minecraft/server/packs/resources/ReloadableResourceManager;f_203816_;List;nonstatic");
        System.out.println("Which means, each modification of list `f_203816_`, which is a nonstatic member in `ReloadableResourceManager`, will be traced - when add and remove is called, a stacktrace will be printed to the log.");
        System.out.println("All valid types:");
        for (Type type : Type.values()) {
            System.out.printf(" -\t%s\n", type.getTypeName());
        }
        System.out.println("All valid phases:");
        for (Enum enum_ : Phase.values()) {
            System.out.printf(" -\t%s\n", ((Phase)enum_).getPhaseName());
        }
        System.out.println();
        System.out.println("Other JVM args:");
        System.out.println(" -Dcme_suck_my_duck.log_level=<level>");
        System.out.println("\tDefault <level>=1, which means no debug message will be logged. If <level> is 0, query functions like Map#get, Set#containsAll will also be logged. This is NOT recommended because it may make the log files too long to be read.");
        System.out.println(" -Dcme_suck_my_duck.asm_api_version=<version>");
        System.out.println("\tDefault <version>=9, which means we use ASM API of version 9.x. For older versions of Minecraft (such as 1.12.2), API level operations such as ASM_9 cannot be applied, so you can set it to a lower value (suck as 5).");
        System.out.println(" -Dcme_suck_my_duck.file_max_entries=<size>");
        System.out.println("\tDefault <size>=1000, which means after every 1000 stack traces, old log file will be deleted, and new log file with 1000 stack traces will be renamed, and a newer log file with the latest stack trace will be create - when system crashes, the latest 1001 ~ 2000 stack traces will be accessible in two log files.");
        System.out.println(" -Dcme_suck_my_duck.log_wait_time=<milliseconds>");
        System.out.println("\tDefault <milliseconds>=500, which means log file I/O will be triggered every half second. All cached stack traces will be logged after log file I/O.");
        System.out.println(" -Dcme_suck_my_duck.whitelist_constructor_stacktrace=<str>");
        System.out.println("\tDefault <str> is an empty string, which means all containers will be monitored if class name matches and field name matches. If not empty, the container will only be monitored if any line in the stack trace where the container is constructed includes the content of <str>.");
        System.out.println(" -Dcme_suck_my_duck.transform_to_thread_safe=<bool>");
        System.out.println("\tDefault <bool>=false. If true, no stack traces will be logged and the container will be converted into a thread-safe container. This is NOT recommended unless you like slowness and don't want to fix the problem.");
        System.out.println(" -Dcme_suck_my_duck.inject_method=<bool>");
        System.out.println("\tDefault <bool>=false. If true, you should use `-javaagent:CMESuckMyDuck-<version>.jar=<class full name>;<method name>` and whenever this method is called, you will receive a stack trace in log files.");
        System.out.println(" -Dcme_suck_my_duck.stop_logging_if_exception_created=<bool>");
        System.out.println("\tDefault <bool>=true. If false, it still keeps logging after critical exception being thrown.");
        System.out.println(" -Dcme_suck_my_duck.trace_id_updater=<class full name>;<method name>");
        System.out.println("\tDefault empty string. If not empty, the given method will also be called to update trace id, which might be useful in `inject_method` mode.");
    }

    public static void premain(String agentArg, Instrumentation inst) {
        try (InputStream is = CMESuckMyDuck.class.getResourceAsStream("/meta.json");){
            String version = ((JsonObject)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(is)), JsonObject.class)).get("version").getAsString();
            logger.info(String.format("CMESuckMyDuck v%s", version));
        }
        catch (Exception e) {
            logger.error("Error getting version of CMESuckMyDuck.");
            logger.error(e);
        }
        String[] args = agentArg.split(";");
        ClassFileTransformer transformer = CMESuckMyDuck.getTransformer(args);
        if (transformer == null) {
            return;
        }
        inst.addTransformer(transformer, true);
        if (TRACE_ID_UPDATER != null && !TRACE_ID_UPDATER.isEmpty()) {
            Object[] updaterArgs = TRACE_ID_UPDATER.split(";");
            if (updaterArgs.length < 2) {
                logger.error("Failed to parse trace id updater arguments. Expect 2 arguments, found %d: [%s].", updaterArgs.length, Log.buildArrayString(updaterArgs));
                return;
            }
            updaterArgs[0] = updaterArgs[0].replace(".", "/");
            inst.addTransformer(new InjectTraceIdUpdaterTransformer((String)updaterArgs[0], (String)updaterArgs[1]), true);
            logger.info("Successfully added trace id updater for method %s of class %s.", updaterArgs[1], updaterArgs[0]);
        }
    }

    @Nullable
    private static ClassFileTransformer getTransformer(String[] args) {
        ClassFileTransformer transformer;
        if (INJECT_METHOD) {
            if (LOCAL_VAR_INDEX != null) {
                logger.error("Cannot inject method when local variable index is specified.");
                return null;
            }
            if (args.length < 2) {
                logger.error("Failed to parse agent arguments. Expect 2 arguments, found %d: [%s].", args.length, Log.buildArrayString(args));
                return null;
            }
            args[0] = args[0].replace(".", "/");
            transformer = new InjectLogTransformer(args[0], args[1]);
            logger.info("Successfully build transformer for method %s of class %s.", args[1], args[0]);
        } else if (LOCAL_VAR_INDEX != null) {
            if (LOCAL_VAR_INDEX < 0) {
                logger.error("Local variable index cannot be negative.");
                return null;
            }
            if (args.length < 3) {
                logger.error("Failed to parse agent arguments. Expect 3 arguments, found %d: [%s].", args.length, Log.buildArrayString(args));
                return null;
            }
            args[0] = args[0].replace(".", "/");
            args[1] = args[1].replace("?", ";");
            transformer = new WrapLocalContainerTransformer(args[0], args[1], Type.fromName(args[2]), LOCAL_VAR_INDEX, MATCH_LOCAL_INDEX);
            logger.info("Successfully build transformer for local field (index %d) of method %s of class %s, type %s.", LOCAL_VAR_INDEX, args[1], args[0], args[2]);
        } else {
            if (args.length < 4) {
                logger.error("Failed to parse agent arguments. Expect 4 arguments, found %d: [%s].", args.length, Log.buildArrayString(args));
                return null;
            }
            args[0] = args[0].replace(".", "/");
            transformer = new WrapContainerTransformer(args[0], args[1], Type.fromName(args[2]), Phase.fromName(args[3]));
            logger.info("Successfully build transformer for field %s of class %s, type %s, phase %s.", args[1], args[0], args[2], args[3]);
        }
        return transformer;
    }

    static {
        int asmApiVersion = 589824;
        try {
            int level = Integer.parseInt(System.getProperty("cme_suck_my_duck.asm_api_version"));
            asmApiVersion = level << 16;
        }
        catch (Exception level) {
            // empty catch block
        }
        ASM_API_VERSION = asmApiVersion;
        boolean injectMethod = false;
        try {
            injectMethod = Boolean.parseBoolean(System.getProperty("cme_suck_my_duck.inject_method"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        INJECT_METHOD = injectMethod;
        Integer localVarIndex = null;
        try {
            localVarIndex = Integer.parseInt(System.getProperty("cme_suck_my_duck.local_var_index"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOCAL_VAR_INDEX = localVarIndex;
        Integer matchLocalIndex = -1;
        try {
            matchLocalIndex = Integer.parseInt(System.getProperty("cme_suck_my_duck.match_local_index"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MATCH_LOCAL_INDEX = matchLocalIndex;
        TRACE_ID_UPDATER = System.getProperty("cme_suck_my_duck.trace_id_updater");
    }
}

