/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.cme_suck_my_duck.containers;

import com.hexagram2021.cme_suck_my_duck.containers.WrappedList;
import com.hexagram2021.cme_suck_my_duck.containers.WrappedMap;
import com.hexagram2021.cme_suck_my_duck.containers.WrappedSet;
import com.hexagram2021.cme_suck_my_duck.containers.iterators.WrappedIterator;
import com.hexagram2021.cme_suck_my_duck.containers.iterators.WrappedListIterator;
import com.hexagram2021.cme_suck_my_duck.utils.Log;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class Containers {
    public static final Log logger = Log.INSTANCE == null ? new Log("CMESuckMyDuck", StandardOpenOption.CREATE, StandardOpenOption.APPEND) : Log.INSTANCE;
    static final boolean transformToThreadSafe;

    public static <T> List<T> newWrappedList(Object wrapped) {
        try {
            if (Log.canWrap()) {
                if (transformToThreadSafe) {
                    return Collections.synchronizedList((List)wrapped);
                }
                return new WrappedList((List)wrapped);
            }
            return (List)wrapped;
        }
        catch (ClassCastException e) {
            logger.fatal(e);
            return Collections.emptyList();
        }
    }

    public static <T> Set<T> newWrappedSet(Object wrapped) {
        try {
            if (Log.canWrap()) {
                if (transformToThreadSafe) {
                    return Collections.synchronizedSet((Set)wrapped);
                }
                return new WrappedSet((Set)wrapped);
            }
            return (Set)wrapped;
        }
        catch (ClassCastException e) {
            logger.fatal(e);
            return Collections.emptySet();
        }
    }

    public static <K, V> Map<K, V> newWrappedMap(Object wrapped) {
        try {
            if (Log.canWrap()) {
                if (transformToThreadSafe) {
                    return Collections.synchronizedMap((Map)wrapped);
                }
                return new WrappedMap((Map)wrapped);
            }
            return (Map)wrapped;
        }
        catch (ClassCastException e) {
            logger.fatal(e);
            return Collections.emptyMap();
        }
    }

    public static <T> Iterator<T> newIterator(Object wrapped) {
        try {
            if (Log.canWrap()) {
                return new WrappedIterator((Iterator)wrapped);
            }
            return (Iterator)wrapped;
        }
        catch (ClassCastException e) {
            logger.fatal(e);
            return Collections.emptyIterator();
        }
    }

    public static <T> ListIterator<T> newListIterator(Object wrapped) {
        try {
            if (Log.canWrap()) {
                return new WrappedListIterator((ListIterator)wrapped);
            }
            return (ListIterator)wrapped;
        }
        catch (ClassCastException e) {
            logger.fatal(e);
            return Collections.emptyListIterator();
        }
    }

    private Containers() {
    }

    static {
        boolean fixConcurrent = false;
        try {
            fixConcurrent = Boolean.parseBoolean(System.getProperty("cme_suck_my_duck.transform_to_thread_safe"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        transformToThreadSafe = fixConcurrent;
    }
}

