/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.cme_suck_my_duck.transformers;

import com.hexagram2021.cme_suck_my_duck.CMESuckMyDuck;
import com.hexagram2021.cme_suck_my_duck.containers.Containers;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class InjectLogTransformer
implements ClassFileTransformer {
    final String className;
    final String methodName;

    public InjectLogTransformer(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        if (className.equals(this.className)) {
            try {
                Containers.logger.info("Found class " + this.className + ".");
                ClassReader reader = new ClassReader(classFileBuffer);
                ClassWriter writer = new ClassWriter(reader, 1);
                reader.accept(new ClassVisitor(CMESuckMyDuck.ASM_API_VERSION, (ClassVisitor)writer){

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        Containers.logger.debug("Visit method " + name + ".");
                        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                        if (name.equals(InjectLogTransformer.this.methodName) || (name + descriptor).equals(InjectLogTransformer.this.methodName)) {
                            Containers.logger.info("Found injection point in method %s.", name + descriptor);
                            return new MethodVisitor(CMESuckMyDuck.ASM_API_VERSION, mv){

                                public void visitCode() {
                                    super.visitCode();
                                    Containers.logger.info("Injecting...");
                                    this.visitMethodInsn(184, "com/hexagram2021/cme_suck_my_duck/utils/TraceIdGenerator", "getGlobalTraceId", "()Ljava/lang/String;", false);
                                    this.visitLdcInsn("Trace");
                                    this.visitMethodInsn(184, "com/hexagram2021/cme_suck_my_duck/utils/TraceLogger", "info", "(Ljava/lang/String;Ljava/lang/String;)V", false);
                                    Containers.logger.info("Injected.");
                                }
                            };
                        }
                        return mv;
                    }
                }, 0);
                return writer.toByteArray();
            }
            catch (Exception e) {
                Containers.logger.error(e);
            }
        }
        return classFileBuffer;
    }
}

