/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.chanceglobe;

import bl4ckscor3.mod.chanceglobe.Configuration;
import bl4ckscor3.mod.chanceglobe.block.ChanceGlobeBlock;
import bl4ckscor3.mod.chanceglobe.block.ChanceGlobeBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="chanceglobe")
@EventBusSubscriber
public class ChanceGlobe {
    public static final String MODID = "chanceglobe";
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"chanceglobe");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"chanceglobe");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"chanceglobe");
    public static final DeferredBlock<ChanceGlobeBlock> CHANCE_GLOBE = BLOCKS.registerBlock("chance_globe", ChanceGlobeBlock::new, BlockBehaviour.Properties.of().strength(5.0f, 10.0f).lightLevel(state -> 3).sound(SoundType.WOOD));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<ChanceGlobeBlockEntity>> CHANCE_GLOBE_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("chance_globe", () -> new BlockEntityType(ChanceGlobeBlockEntity::new, new Block[]{(Block)CHANCE_GLOBE.get()}));
    public static final DeferredItem<BlockItem> CHANCE_GLOBE_ITEM = ITEMS.registerSimpleBlockItem("chance_globe", CHANCE_GLOBE);
    public static List<ItemStack> blocksAndItems = new ArrayList<ItemStack>();

    public ChanceGlobe(IEventBus modEventBus, ModContainer modContainer) {
        BLOCKS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        ITEMS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.CONFIG_SPEC);
    }

    @SubscribeEvent
    public static void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)CHANCE_GLOBE_ITEM.get());
        }
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        ChanceGlobe.generateItemStacks();
    }

    @SubscribeEvent
    public static void onModConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals(MODID)) {
            ChanceGlobe.generateItemStacks();
        }
    }

    private static void generateItemStacks() {
        ResourceLocation registryName;
        ArrayList<ItemStack> newBlocksAndItems = new ArrayList<ItemStack>();
        NonNullList temp = NonNullList.create();
        block8: for (Block block : BuiltInRegistries.BLOCK) {
            if (((Boolean)Configuration.CONFIG.enableFilter.get()).booleanValue()) {
                registryName = BuiltInRegistries.BLOCK.getKey((Object)block);
                switch ((Integer)Configuration.CONFIG.filterMode.get()) {
                    case 0: {
                        if (!((List)Configuration.CONFIG.filteredMods.get()).contains(registryName.getNamespace()) && !((List)Configuration.CONFIG.filteredBlocks.get()).contains(registryName.toString())) break;
                        continue block8;
                    }
                    case 1: {
                        if (((List)Configuration.CONFIG.filteredMods.get()).contains(registryName.getNamespace()) || ((List)Configuration.CONFIG.filteredBlocks.get()).contains(registryName.toString())) break;
                        continue block8;
                    }
                }
            }
            temp.add((Object)new ItemStack((ItemLike)block));
        }
        block9: for (Item item : BuiltInRegistries.ITEM) {
            if (item instanceof BlockItem) continue;
            if (((Boolean)Configuration.CONFIG.enableFilter.get()).booleanValue()) {
                registryName = BuiltInRegistries.ITEM.getKey((Object)item);
                switch ((Integer)Configuration.CONFIG.filterMode.get()) {
                    case 0: {
                        if (!((List)Configuration.CONFIG.filteredMods.get()).contains(registryName.getNamespace()) && !((List)Configuration.CONFIG.filteredItems.get()).contains(registryName.toString())) break;
                        continue block9;
                    }
                    case 1: {
                        if (((List)Configuration.CONFIG.filteredMods.get()).contains(registryName.getNamespace()) || ((List)Configuration.CONFIG.filteredItems.get()).contains(registryName.toString())) break;
                        continue block9;
                    }
                }
            }
            temp.add((Object)new ItemStack((ItemLike)item));
        }
        block10: for (ItemStack stack : temp) {
            if (stack == null || stack.isEmpty()) continue;
            for (ItemStack bi : newBlocksAndItems) {
                if (bi != null && !stack.is(bi.getItem())) continue;
                continue block10;
            }
            newBlocksAndItems.add(stack);
        }
        Collections.shuffle(newBlocksAndItems);
        blocksAndItems.clear();
        blocksAndItems.addAll(newBlocksAndItems);
    }
}

