/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.chanceglobe;

import com.google.common.collect.Lists;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    public static final ModConfigSpec CONFIG_SPEC;
    public static final Configuration CONFIG;
    public final ModConfigSpec.BooleanValue enableFilter;
    public final ModConfigSpec.IntValue filterMode;
    public final ModConfigSpec.ConfigValue<List<? extends String>> filteredBlocks;
    public final ModConfigSpec.ConfigValue<List<? extends String>> filteredItems;
    public final ModConfigSpec.ConfigValue<List<? extends String>> filteredMods;
    public final ModConfigSpec.DoubleValue durationMultiplier;

    Configuration(ModConfigSpec.Builder builder) {
        this.enableFilter = builder.comment("Enable deny- or allowlisting items and blocks.").define("enable_filter", true);
        this.filterMode = builder.comment("Set to 0 for denylist (all blocks/items EXCEPT the ones listed will be used for randomization), 1 for allowlist (only the blocks/items listed will be used for randomization). Make sure to set enable_filter to true if you want to use the lists.").defineInRange("filter_mode", 0, 0, 1);
        this.filteredBlocks = builder.comment("These blocks will be filtered if enable_filter is set to true. Whether to use allow- or denylisting is defined by the filter_mode option. Use the block's registry name. E.g. to filter grass, use minecraft:grass").defineList("filtered_blocks", (List)Lists.newArrayList((Object[])new String[]{"minecraft:barrier", "minecraft:bedrock", "minecraft:dragon_egg", "minecraft:chain_command_block", "minecraft:command_block", "minecraft:jigsaw", "minecraft:spawner", "minecraft:repeating_command_block", "minecraft:structure_block", "minecraft:structure_void", "minecraft:light"}), e -> e instanceof String);
        this.filteredItems = builder.comment("These items will be filtered if enable_filter is set to true. Whether to use allow- or denylisting is defined by the filter_mode option. Use the item's registry name. E.g. to filter sticks, use minecraft:stick").defineList("filtered_items", (List)Lists.newArrayList((Object[])new String[]{"minecraft:command_block_minecart", "minecraft:knowledge_book"}), e -> e instanceof String);
        this.filteredMods = builder.comment("These mods will be filtered according to filter_mode if enable_filter is set to true. This list contains mod IDs.").defineList("filtered_mods", (List)Lists.newArrayList(), e -> e instanceof String);
        this.durationMultiplier = builder.comment("The default duration until a block gets placed/an item drops is 10 seconds. With this multiplier, you can change the timing. E.g. setting the value to 2 will make the duration twice as long (20 seconds).").defineInRange("duration_multiplier", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Configuration::new);
        CONFIG_SPEC = (ModConfigSpec)specPair.getRight();
        CONFIG = (Configuration)specPair.getLeft();
    }
}

