/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.chanceglobe.block;

import bl4ckscor3.mod.chanceglobe.ChanceGlobe;
import bl4ckscor3.mod.chanceglobe.block.ChanceGlobeBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChanceGlobeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED;
    public static final VoxelShape SHAPE;

    public ChanceGlobeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter source, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ChanceGlobeBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ChanceGlobeBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ChanceGlobe.CHANCE_GLOBE_BLOCK_ENTITY.get()), (BlockEntityTicker)(level.isClientSide() ? ChanceGlobeBlockEntity::clientTick : ChanceGlobeBlockEntity::serverTick));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    static {
        VoxelShape[] allShapes;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        VoxelShape returnShape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
        for (VoxelShape shape : allShapes = new VoxelShape[]{Block.box((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)7.0, (double)14.0), Block.box((double)2.0, (double)6.0, (double)6.0, (double)14.0, (double)7.0, (double)10.0), Block.box((double)4.0, (double)6.0, (double)3.0, (double)12.0, (double)7.0, (double)13.0), Block.box((double)3.0, (double)6.0, (double)4.0, (double)13.0, (double)7.0, (double)12.0), Block.box((double)7.0, (double)7.0, (double)2.0, (double)9.0, (double)8.0, (double)14.0), Block.box((double)2.0, (double)7.0, (double)7.0, (double)14.0, (double)8.0, (double)9.0), Block.box((double)3.0, (double)7.0, (double)5.0, (double)13.0, (double)9.0, (double)11.0), Block.box((double)5.0, (double)7.0, (double)3.0, (double)11.0, (double)9.0, (double)13.0), Block.box((double)3.0, (double)7.0, (double)4.0, (double)13.0, (double)8.0, (double)12.0), Block.box((double)4.0, (double)7.0, (double)3.0, (double)12.0, (double)8.0, (double)13.0), Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.box((double)3.0, (double)9.0, (double)6.0, (double)13.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)9.0, (double)3.0, (double)10.0, (double)10.0, (double)13.0), Block.box((double)4.0, (double)9.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0), Block.box((double)5.0, (double)9.0, (double)4.0, (double)11.0, (double)10.0, (double)12.0), Block.box((double)4.0, (double)10.0, (double)6.0, (double)12.0, (double)11.0, (double)10.0), Block.box((double)6.0, (double)10.0, (double)4.0, (double)10.0, (double)11.0, (double)12.0), Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)6.0, (double)11.0, (double)7.0, (double)10.0, (double)12.0, (double)9.0), Block.box((double)7.0, (double)11.0, (double)6.0, (double)9.0, (double)12.0, (double)10.0)}) {
            returnShape = Shapes.or((VoxelShape)returnShape, (VoxelShape)shape);
        }
        SHAPE = returnShape;
    }
}

