/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.chanceglobe.block;

import bl4ckscor3.mod.chanceglobe.ChanceGlobe;
import bl4ckscor3.mod.chanceglobe.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChanceGlobeBlockEntity
extends BlockEntity {
    public static final Random random = new Random(System.currentTimeMillis());
    private ItemStack clientItem = ItemStack.EMPTY;
    public ItemStack serverItem = ItemStack.EMPTY;
    public final double secondsUntilDrop;
    public double tickToDrop;
    public int ticksUntilDrop;
    public int ticksUntilChange;
    private final List<ItemStack> blocksAndItems;

    public ChanceGlobeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ChanceGlobe.CHANCE_GLOBE_BLOCK_ENTITY.get(), pos, state);
        this.secondsUntilDrop = 10.0 * (Double)Configuration.CONFIG.durationMultiplier.get();
        this.tickToDrop = this.secondsUntilDrop * 20.0;
        this.ticksUntilDrop = 0;
        this.ticksUntilChange = this.getNextChangeTick(this.ticksUntilDrop);
        this.blocksAndItems = new ArrayList<ItemStack>();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.blocksAndItems.clear();
        this.blocksAndItems.addAll(ChanceGlobe.blocksAndItems.stream().filter(stack -> stack.getItem().requiredFeatures().isSubsetOf(level.enabledFeatures())).toList());
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ChanceGlobeBlockEntity be) {
        if (be.blocksAndItems.size() <= 0) {
            return;
        }
        if (be.ticksUntilChange == 0 || be.clientItem.isEmpty()) {
            be.ticksUntilChange = be.getNextChangeTick(be.ticksUntilDrop);
            be.clientItem = be.blocksAndItems.get(random.nextInt(be.blocksAndItems.size()));
        } else {
            --be.ticksUntilChange;
        }
        if ((double)be.ticksUntilDrop != be.tickToDrop) {
            ++be.ticksUntilDrop;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ChanceGlobeBlockEntity be) {
        if (be.blocksAndItems.size() <= 0) {
            return;
        }
        if (be.serverItem.isEmpty()) {
            be.serverItem = be.blocksAndItems.get(random.nextInt(be.blocksAndItems.size()));
        }
        if ((double)be.ticksUntilDrop++ == be.tickToDrop) {
            level.destroyBlock(be.worldPosition, false);
            Item item = be.serverItem.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                level.setBlockAndUpdate(be.worldPosition, blockItem.getBlock().defaultBlockState());
            } else {
                Block.popResource((Level)level, (BlockPos)be.worldPosition, (ItemStack)be.serverItem);
            }
        }
    }

    public ItemStack getClientItem() {
        return this.clientItem;
    }

    public int getNextChangeTick(int remainingTicksToDrop) {
        return (int)(Math.pow((double)(remainingTicksToDrop / 20) - this.secondsUntilDrop, 2.0) / 2.5);
    }
}

