/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.ai.goals.mining;

import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.ai.goals.BreakBlockGoal;
import net.picopress.mc.mods.zombietactics2.attachments.MiningData;
import net.picopress.mc.mods.zombietactics2.attachments.MiningRoutines;
import net.picopress.mc.mods.zombietactics2.util.Tactics;
import org.jetbrains.annotations.NotNull;

public class MonsterBreakBlockGoal<T extends class_1588>
extends BreakBlockGoal {
    private final T zombie;
    double max_p2;
    double min_p2;
    public MiningData mine;

    public MonsterBreakBlockGoal(T zombie, MiningData mine) {
        super((class_1308)zombie, mine, Config.hardnessMultiplier, Config.break_speed, Config.dropBlocks);
        this.mine = mine;
        this.zombie = zombie;
    }

    protected class_2338[] getCandidate(@NotNull class_1309 liv) {
        double deltaY = liv.method_23318() - this.zombie.method_23318();
        if (deltaY > -2.0 && deltaY < 2.0) {
            return MiningRoutines.routineFlat;
        }
        if (deltaY <= -2.0) {
            return MiningRoutines.routineDown;
        }
        return MiningRoutines.routineUp;
    }

    @Override
    protected boolean checkBlock(class_2338 pos) {
        boolean ret;
        float destroying = this.getBlockHardness(pos);
        boolean bl = ret = super.checkBlock(pos) && (double)destroying <= Config.maxHardness && !this.zombie.method_73183().method_8320(pos).method_26164(class_3481.field_15495);
        if (ret) {
            this.mine.bp = pos;
            this.mine.bp_vec3 = pos.method_46558();
            this.mine.doMining = true;
        }
        return ret;
    }

    @Override
    public boolean method_6266() {
        return super.method_6266() && this.zombie.method_5707(this.mine.bp_vec3) <= this.max_p2;
    }

    @Override
    public void method_6268() {
        double dist = this.zombie.method_5707(this.mine.bp_vec3);
        if (dist < this.min_p2 || dist > this.max_p2) {
            this.mine.doMining = false;
            return;
        }
        super.method_6268();
    }

    @Override
    public boolean method_6264() {
        if (!super.method_6264()) {
            return false;
        }
        double len = this.zombie.method_18798().method_1033();
        if ((len > 0.8 || Config.strictMine && len > 0.1) && !Config.canFly) {
            return false;
        }
        class_1309 liv = this.zombie.method_5968();
        class_1408 nav = this.zombie.method_5942();
        if (liv != null) {
            nav.method_6349((class_1297)liv, 0);
        }
        if (nav.method_6357() && liv != null && nav.method_6345() != null && !nav.method_6345().method_21655()) {
            class_2338[] set;
            if (this.zombie.method_42150(liv) && this.zombie.method_6057((class_1297)liv)) {
                return false;
            }
            if (nav.method_6335((class_1297)liv, (double)this.zombie.method_6029())) {
                return false;
            }
            for (class_2338 pos : set = this.getCandidate(liv)) {
                class_2338 temp = this.zombie.method_24515().method_10081((class_2382)pos.method_10070(Tactics.getRelativeRotation(this.zombie)));
                if (!this.checkBlock(temp)) continue;
                return true;
            }
        } else if (this.zombie.method_5757()) {
            for (class_2338 p : MiningRoutines.routineWall) {
                class_2338 temp = this.zombie.method_24515().method_10081((class_2382)p);
                if (!this.checkBlock(temp)) continue;
                return true;
            }
        } else {
            class_2338 head2 = this.zombie.method_24515().method_10086(2);
            if (this.zombie.method_5777(class_3486.field_15517) && this.zombie.method_73183().method_8320(head2).method_26225()) {
                return this.checkBlock(head2);
            }
        }
        return false;
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.min_p2 = Config.minDist * Config.minDist;
        this.max_p2 = Config.maxDist * Config.maxDist;
    }
}

