/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.ai.goals.target;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4051;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.attachments.FindTargetType;
import net.picopress.mc.mods.zombietactics2.impl.Plane;
import net.picopress.mc.mods.zombietactics2.util.Tactics;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class FindAllTargetsGoal
extends class_1405 {
    public static final Map<class_1309, class_11> cache_path = new HashMap<class_1309, class_11>();
    private final List<Pair<Class<? extends class_1309>, Integer>> list;
    private final Plane plane;
    private List<class_1309> imposters;
    private class_4051 targetingConditions;
    @Nullable
    private final class_3218 serverLevel;
    private Task task;
    private int delay;
    private int idx;

    public FindAllTargetsGoal(List<Pair<Class<? extends class_1309>, Integer>> targets, class_1308 mob, boolean mustSee) {
        super(mob, mustSee);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        this.list = targets;
        this.serverLevel = Tactics.getServerLevel(mob);
        this.plane = (Plane)mob;
        this.targetingConditions = class_4051.method_36625().method_18418((double)Config.followRange).method_18420(null);
        if (Config.attackInvisible) {
            this.targetingConditions = this.targetingConditions.method_36627();
        }
    }

    public boolean method_6264() {
        return this.field_6660.method_5968() == null || !this.field_6660.method_5968().method_5805() || this.plane.zombietactics2$shouldAlert();
    }

    public void method_6269() {
        this.idx = 0;
        this.delay = 0;
        this.task = Task.IDLE;
    }

    public void method_6268() {
        if (this.serverLevel == null) {
            return;
        }
        if (this.task == Task.IDLE) {
            ++this.delay;
            if (Config.findTargetType == FindTargetType.SIMPLE && this.delay > 4) {
                this.task = Task.SEARCH;
            } else if (this.delay > 6) {
                this.task = Task.SEARCH;
            }
        } else if (this.task == Task.SEARCH) {
            if (Config.findTargetType == FindTargetType.SIMPLE) {
                Pair<Class<? extends class_1309>, Integer> clazz = this.list.get(this.idx);
                Object target = clazz.getA() != class_1657.class && clazz.getA() != class_3222.class ? this.serverLevel.method_64391((Class)clazz.getA(), this.targetingConditions, (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321(), this.followBox()) : this.serverLevel.method_64389(this.targetingConditions, (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321());
                if (this.field_6660.method_5968() == null || target != null && this.field_6660.method_5968() != null && this.field_6660.method_5858((class_1297)target) < this.field_6660.method_5858((class_1297)this.field_6660.method_5968())) {
                    this.field_6660.method_5980((class_1309)target);
                }
                ++this.idx;
                this.idx %= this.list.size();
                this.task = Task.IDLE;
            } else {
                this.imposters = this.field_6660.method_73183().method_8390(class_1309.class, this.followBox(), t -> {
                    for (Pair<Class<? extends class_1309>, Integer> sus : this.list) {
                        if (!((Class)sus.getA()).isAssignableFrom(t.getClass()) || !this.targetingConditions.method_18419(this.serverLevel, (class_1309)this.field_6660, t)) continue;
                        return true;
                    }
                    return false;
                });
                this.task = Task.PRIORITIZE;
            }
            this.delay = 0;
        } else if (this.task == Task.PRIORITIZE) {
            class_2338 me = this.field_6660.method_24515();
            class_1309 target = null;
            int minimumCost = Integer.MAX_VALUE;
            for (class_1309 amogus : this.imposters) {
                class_11 path;
                class_2338 delta = me.method_10059((class_2382)amogus.method_24515());
                int score = 0;
                int idx = 0;
                if (Config.findTargetType == FindTargetType.INTENSIVE) {
                    path = cache_path.get(amogus);
                    if (path == null) {
                        path = this.field_6660.method_5942().method_6349((class_1297)amogus, Config.accuracy);
                        cache_path.put(amogus, path);
                    }
                    if (path != null) {
                        score += path.method_38();
                        if (!path.method_21655()) {
                            score *= 128;
                        }
                    }
                } else if (Config.findTargetType == FindTargetType.LINEAR) {
                    class_2338.class_2339 bp = this.field_6660.method_24515().method_25503();
                    double len = this.field_6660.method_5739((class_1297)amogus);
                    int i = 0;
                    while ((double)i <= len) {
                        double cache = (double)i / len;
                        score = !this.field_6660.method_73183().method_8320((class_2338)bp.method_10102((double)delta.method_10263() * cache, (double)delta.method_10264() * cache, (double)delta.method_10260() * cache)).method_26215() ? (score += Config.blockCost) : ++score;
                        ++i;
                    }
                } else if (Config.findTargetType == FindTargetType.OVERLOAD && (path = this.field_6660.method_5942().method_6349((class_1297)amogus, Config.accuracy)) != null) {
                    score += path.method_38();
                    if (!path.method_21655()) {
                        score *= 128;
                    }
                }
                for (Pair<Class<? extends class_1309>, Integer> p : this.list) {
                    if (((Class)p.getA()).isAssignableFrom(amogus.getClass())) break;
                    ++idx;
                }
                score *= ((Integer)this.list.get(idx).getB()).intValue();
                if (this.field_6660.method_6057((class_1297)amogus)) {
                    score /= 2;
                }
                if (delta.method_10264() >= -2) {
                    score /= 2;
                }
                if ((score *= Tactics.Heuristic.getEnemyPower(amogus)) >= minimumCost) continue;
                minimumCost = score;
                target = amogus;
            }
            if (target != null) {
                this.field_6660.method_5980(target);
            }
            this.task = Task.IDLE;
        }
    }

    public boolean method_6266() {
        return this.method_6264() || super.method_6266();
    }

    private class_238 followBox() {
        return this.plane.zombietactics2$getFollowingArea();
    }

    public static enum Task {
        SEARCH,
        PRIORITIZE,
        IDLE;

    }
}

