/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.server.MinecraftServer;
import net.picopress.mc.mods.zombietactics2.impl.Plane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tactics {
    public static final class_2338 UNIT_FRONT = new class_2338(0, 0, 1);

    public static class_2470 getRelativeRotation(class_1308 mob) {
        class_2382 norm = mob.method_58149().method_62675();
        int x = norm.method_10263();
        int z = norm.method_10260();
        if (x == 0 && z == 1) {
            return class_2470.field_11467;
        }
        if (x == 0 && z == -1) {
            return class_2470.field_11464;
        }
        if (x == -1 && z == 0) {
            return class_2470.field_11463;
        }
        return class_2470.field_11465;
    }

    public static float getExactDamage(@NotNull class_1308 mob, class_1309 target) {
        class_3218 serverLevel = Tactics.getSl(mob);
        class_1324 tmp = mob.method_5996(class_5134.field_23721);
        if (tmp == null) {
            return 0.0f;
        }
        float dam = (float)tmp.method_6194();
        if (serverLevel == null) {
            return dam;
        }
        return class_1890.method_60120((class_3218)serverLevel, (class_1799)mob.method_59958(), (class_1297)target, (class_1282)mob.method_48923().method_48812((class_1309)mob), (float)dam);
    }

    public static class_3218 getSl(class_1308 mob) {
        MinecraftServer stuff = mob.method_73183().method_8503();
        return stuff != null ? stuff.method_3847(mob.method_73183().method_27983()) : null;
    }

    public static class_3218 getServerLevel(class_1308 mob) {
        return Tactics.getSl(mob);
    }

    private Tactics() {
    }

    public static class World {
        public static class_2818[] getNearbyChunks(class_1937 level, class_2338 pos) {
            class_2818[] list = new class_2818[9];
            int idx = 0;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    list[idx] = level.method_8500(pos.method_10069(16 * i, 0, 16 * j));
                    ++idx;
                }
            }
            return list;
        }

        public static List<class_2338> findBlocks(class_1937 level, class_238 aabb, @Nullable class_2248 block) {
            return World.findBlocks(level, block, (int)aabb.field_1323, (int)aabb.field_1322, (int)aabb.field_1321, (int)aabb.field_1320, (int)aabb.field_1325, (int)aabb.field_1324);
        }

        public static List<class_2338> findBlocks(class_1937 level, @Nullable class_2248 block, int x1, int y1, int z1, int x2, int y2, int z2) {
            ArrayList<class_2338> list = new ArrayList<class_2338>();
            class_2338.class_2339 point = new class_2338.class_2339();
            for (int x = x1; x <= x2; ++x) {
                for (int y = y1; y <= y2; ++y) {
                    for (int z = z1; z <= z2; ++z) {
                        point.method_10103(x, y, z);
                        if (!level.method_8320((class_2338)point).method_27852(block) && block != null) continue;
                        list.add(point.method_10062());
                    }
                }
            }
            return list;
        }

        public static int ManhattanDistance(class_2338 p1, class_2338 p2) {
            return Math.abs(p1.method_10263() - p2.method_10263()) + Math.abs(p1.method_10264() - p2.method_10264()) + Math.abs(p1.method_10260() - p2.method_10260());
        }
    }

    public static class ItemUtil {
        static double getDefensePoint(class_1799 item) {
            class_1322 armor = ItemUtil.getItemAttr(item, "armor");
            class_1322 toughness = ItemUtil.getItemAttr(item, "armor_toughness");
            if (armor == null || toughness == null) {
                return 0.0;
            }
            return (armor.comp_2449() + 1.0) * (toughness.comp_2449() + 1.0);
        }

        @Nullable
        public static class_1322 getItemAttr(class_1799 stack, String path, String namespace) {
            class_9285 component = (class_9285)stack.method_57353().method_58694(class_9334.field_49636);
            if (component == null) {
                return null;
            }
            List list = component.comp_2393();
            class_9285.class_9287 entry = null;
            for (class_9285.class_9287 attr : list) {
                if (!attr.comp_2395().method_40226(class_2960.method_60655((String)namespace, (String)path))) continue;
                entry = attr;
                break;
            }
            if (entry == null) {
                return null;
            }
            return entry.comp_2396();
        }

        @Nullable
        public static class_1322 getItemAttr(class_1799 stack, String path) {
            return ItemUtil.getItemAttr(stack, path, "minecraft");
        }

        public static boolean isBetter(class_1308 me, class_1799 dropped) {
            class_1799 my = null;
            double test1 = 0.0;
            double test2 = 0.0;
            boolean is_armor = false;
            if (dropped.method_31573(class_3489.field_48305)) {
                my = me.method_6047();
                if (my.method_31574(class_1802.field_8162)) {
                    return my.method_31574(class_1802.field_8162);
                }
                class_1322 my_weapon = ItemUtil.getItemAttr(my, "attack_damage");
                class_1322 other = ItemUtil.getItemAttr(dropped, "attack_damage");
                if (my_weapon == null || other == null) {
                    return false;
                }
                test1 = my_weapon.comp_2449();
                test2 = other.comp_2449();
            } else if (dropped.method_31573(class_3489.field_48303)) {
                my = me.method_6118(me.method_32326(dropped));
                if (class_1890.method_60142((class_1799)my, (class_9331)class_9701.field_51656)) {
                    return false;
                }
                if (my.method_31574(class_1802.field_8162)) {
                    return true;
                }
                if (my.method_31573(class_3489.field_48303)) {
                    test1 = ItemUtil.getDefensePoint(my);
                    test2 = ItemUtil.getDefensePoint(dropped);
                }
            }
            if (my == null) {
                return false;
            }
            if (test1 < test2) {
                return true;
            }
            if (test1 == test2 && !is_armor) {
                if (my.method_7919() > dropped.method_7919()) {
                    return true;
                }
                return ItemUtil.checkDamageable(dropped) && !ItemUtil.checkDamageable(my);
            }
            return false;
        }

        private static boolean checkDamageable(class_1799 stack) {
            class_9323 dataComponentMap = stack.method_57353();
            int i = dataComponentMap.method_57835();
            return i > 1 || i == 1 && !dataComponentMap.method_57832(class_9334.field_49629);
        }
    }

    public static class Heuristic {
        public static int getEnemyPower(class_1309 target) {
            class_1324 attack = target.method_5996(class_5134.field_23721);
            return (int)((attack != null ? attack.method_6194() : 0.0) / 2.0 * (double)target.method_6032() / 5.0 * (double)target.method_6029() + 1.0);
        }

        public static boolean simulate(Class<? extends class_1309> clazz, class_1308 mob, class_1309 target) {
            List peers = mob.method_73183().method_8390(clazz, ((Plane)mob).zombietactics2$getFollowingArea(), liv -> liv != mob);
            if (peers.size() > 15) {
                return true;
            }
            int opponent = Heuristic.getEnemyPower(target);
            int me = Heuristic.getEnemyPower((class_1309)mob);
            int peer_power = 0;
            for (class_1309 peer : peers) {
                peer_power += Heuristic.getEnemyPower(peer);
            }
            return me + peer_power >= opponent;
        }

        public static boolean needAvoid(class_1308 mob, class_1309 target) {
            if (target == null) {
                return false;
            }
            class_1324 attack = target.method_5996(class_5134.field_23721);
            if (attack != null) {
                return (double)mob.method_6032() <= attack.method_6194() && (double)target.method_6032() > mob.method_45325(class_5134.field_23721);
            }
            return false;
        }
    }
}

