/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.goals.target;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.picopress.mc.mods.zombietactics2.Config;

public class GoToWantedItemGoal
extends Goal {
    private final Mob mob;
    private final Predicate<ItemStack> predicate;
    private ItemEntity target;
    private int delay = 0;
    private final int range;

    public GoToWantedItemGoal(Mob mob, Predicate<ItemStack> predicate) {
        this(mob, predicate, Config.pickupRange);
    }

    public GoToWantedItemGoal(Mob mob, Predicate<ItemStack> predicate, int range) {
        this.mob = mob;
        this.predicate = predicate;
        this.range = range;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (Config.pickupRange == 0) {
            return false;
        }
        ++this.delay;
        if (this.delay < 10) {
            return false;
        }
        this.delay = 0;
        List items = this.mob.level().getEntitiesOfClass(ItemEntity.class, new AABB(this.mob.getX() - (double)this.range, this.mob.getY() - (double)this.range, this.mob.getZ() - (double)this.range, this.mob.getX() + (double)this.range, this.mob.getY() + (double)this.range, this.mob.getZ() + (double)this.range));
        for (ItemEntity item : items) {
            ItemStack stack = item.getItem();
            if (!this.predicate.test(stack) || item.isInWater() || item.isInLava()) continue;
            this.mob.getNavigation().moveTo((Entity)item, 1.0);
            this.target = item;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone() && !this.target.isRemoved();
    }
}

