/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.mixin;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.WritableLevelData;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.attachments.FindTargetType;
import net.picopress.mc.mods.zombietactics2.goals.target.FindAllTargetsGoal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import oshi.util.tuples.Pair;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level {
    @Unique
    private static int zombie_tactics$duration = 0;

    protected ServerLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, Supplier<ProfilerFiller> profiler, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, profiler, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Inject(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="TAIL")})
    public void tick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        if (Config.findTargetType == FindTargetType.INTENSIVE && ++zombie_tactics$duration > 20) {
            zombie_tactics$duration = 0;
            while (true) {
                boolean mark = true;
                int idx = 0;
                for (Pair<LivingEntity, Path> cp : FindAllTargetsGoal.cache_path) {
                    if (!((LivingEntity)cp.getA()).isAlive()) {
                        mark = false;
                        break;
                    }
                    ++idx;
                }
                if (mark) break;
                FindAllTargetsGoal.cache_path.remove(idx);
            }
        }
    }
}

