/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.neoforge;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.attachments.FindTargetType;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(modid="zombietactics2", bus=EventBusSubscriber.Bus.MOD)
public class NeoForgeConfig {
    private static final Pair<build, ModConfigSpec> BUILDER = new ModConfigSpec.Builder().configure(build::new);
    private static ModConfigSpec.BooleanValue TARGET_ANIMALS;
    private static ModConfigSpec.BooleanValue ATTACK_INVISIBLE;
    private static ModConfigSpec.BooleanValue MINE_BLOCKS;
    private static ModConfigSpec.DoubleValue MIN_DISTANCE;
    private static ModConfigSpec.DoubleValue MAX_DISTANCE;
    private static ModConfigSpec.BooleanValue DROP_BROKEN_BLOCKS;
    private static ModConfigSpec.BooleanValue ZOMBIE_CLIMBING;
    private static ModConfigSpec.DoubleValue CLIMBING_SPEED;
    private static ModConfigSpec.DoubleValue MINING_SPEED;
    private static ModConfigSpec.DoubleValue MAX_HARDNESS;
    private static ModConfigSpec.DoubleValue HARDNESS_MULTIPLIER;
    private static ModConfigSpec.DoubleValue HEAL_AMOUNT;
    private static ModConfigSpec.IntValue ATTACK_COOLDOWN;
    private static ModConfigSpec.DoubleValue AGGRESSIVE_SPEED;
    private static ModConfigSpec.BooleanValue SUN_SENSITIVE;
    private static ModConfigSpec.BooleanValue NO_MERCY;
    private static ModConfigSpec.DoubleValue ATTACK_RANGE;
    private static ModConfigSpec.DoubleValue PERSISTENCE_CHANCE;
    private static ModConfigSpec.IntValue MAX_THRESHOLD;
    private static ModConfigSpec.IntValue BLOCK_COST;
    private static ModConfigSpec.BooleanValue CAN_FLOAT;
    private static ModConfigSpec.IntValue CLIMB_LIMIT_TICKS;
    private static ModConfigSpec.DoubleValue JUMP_ACCELERATION;
    private static ModConfigSpec.BooleanValue HYPER_CLIMBING;
    private static ModConfigSpec.BooleanValue JUMP_BLOCK;
    private static ModConfigSpec.IntValue FOLLOW_RANGE;
    private static ModConfigSpec.EnumValue<FindTargetType> TARGET_TYPE;
    private static ModConfigSpec.BooleanValue SPAWN_UNDER_SUN;
    private static ModConfigSpec.BooleanValue CAN_FLY;
    private static ModConfigSpec.DoubleValue FLY_SPEED;
    private static ModConfigSpec.IntValue PATH_ACCURACY;
    private static ModConfigSpec.IntValue PICKUP_RANGE;
    private static ModConfigSpec.BooleanValue RANDOM_CLIMB;
    private static ModConfigSpec.BooleanValue STRICT_MINE;
    private static ModConfigSpec.BooleanValue NO_DESPAWN;
    private static ModConfigSpec.BooleanValue NO_IDLE;
    private static ModConfigSpec.BooleanValue BREAK_CHEST;
    private static ModConfigSpec.IntValue FIND_CHEST_RANGE;
    private static ModConfigSpec.BooleanValue SHOW_NODES;
    private static ModConfigSpec.BooleanValue SHOW_DELTA_MOVEMENT;
    static final ModConfigSpec SPEC;

    @SubscribeEvent
    static void onLoad(ModConfigEvent ignored) {
        Config.mineBlocks = (Boolean)MINE_BLOCKS.get();
        Config.minDist = (Double)MIN_DISTANCE.get();
        Config.maxDist = (Double)MAX_DISTANCE.get();
        Config.dropBlocks = (Boolean)DROP_BROKEN_BLOCKS.get();
        Config.targetAnimals = (Boolean)TARGET_ANIMALS.get();
        Config.attackInvisible = (Boolean)ATTACK_INVISIBLE.get();
        Config.break_speed = (Double)MINING_SPEED.get();
        Config.maxHardness = (Double)MAX_HARDNESS.get();
        Config.hardnessMultiplier = (Double)HARDNESS_MULTIPLIER.get();
        Config.zombiesClimbing = (Boolean)ZOMBIE_CLIMBING.get();
        Config.climbingSpeed = (Double)CLIMBING_SPEED.get();
        Config.healAmount = (Double)HEAL_AMOUNT.get();
        Config.attackCooldown = (Integer)ATTACK_COOLDOWN.get();
        Config.aggressiveSpeed = (Double)AGGRESSIVE_SPEED.get();
        Config.sunSensitive = (Boolean)SUN_SENSITIVE.get();
        Config.noMercy = (Boolean)NO_MERCY.get();
        Config.attackRange = (Double)ATTACK_RANGE.get();
        Config.persistenceChance = (Double)PERSISTENCE_CHANCE.get();
        Config.maxThreshold = (Integer)MAX_THRESHOLD.get();
        Config.blockCost = (Integer)BLOCK_COST.get();
        Config.canFloat = (Boolean)CAN_FLOAT.get();
        Config.climbLimitTicks = (Integer)CLIMB_LIMIT_TICKS.get();
        Config.jumpAcceleration = (Double)JUMP_ACCELERATION.get();
        Config.hyperClimbing = (Boolean)HYPER_CLIMBING.get();
        Config.jumpBlock = (Boolean)JUMP_BLOCK.get();
        Config.followRange = (Integer)FOLLOW_RANGE.get();
        Config.findTargetType = (FindTargetType)((Object)TARGET_TYPE.get());
        Config.spawnUnderSun = (Boolean)SPAWN_UNDER_SUN.get();
        Config.canFly = (Boolean)CAN_FLY.get();
        Config.flySpeed = (Double)FLY_SPEED.get();
        Config.showNodes = (Boolean)SHOW_NODES.get();
        Config.accuracy = (Integer)PATH_ACCURACY.get();
        Config.pickupRange = (Integer)PICKUP_RANGE.get();
        Config.showDeltaMovement = (Boolean)SHOW_DELTA_MOVEMENT.get();
        Config.randomlyClimb = (Boolean)RANDOM_CLIMB.get();
        Config.strictMine = (Boolean)STRICT_MINE.get();
        Config.noDespawn = (Boolean)NO_DESPAWN.get();
        Config.noIdle = (Boolean)NO_IDLE.get();
        Config.breakChest = (Boolean)BREAK_CHEST.get();
        Config.findChest = (Integer)FIND_CHEST_RANGE.get();
    }

    static {
        SPEC = (ModConfigSpec)BUILDER.getRight();
    }

    public static class build {
        static final String MOD_CFG = "zombietactics2.midnightconfig.";

        public build(ModConfigSpec.Builder b) {
            b.push("Mining");
            MINE_BLOCKS = b.translation("zombietactics2.midnightconfig.do_mine").define("zombiesMineBlocks", Config.mineBlocks);
            MINING_SPEED = b.translation("zombietactics2.midnightconfig.mining_speed").defineInRange("miningSpeed", Config.break_speed, 0.0, Double.MAX_VALUE);
            MIN_DISTANCE = b.translation("zombietactics2.midnightconfig.min_mine_dist").defineInRange("minDistForMining", Config.minDist, 0.0, Double.MAX_VALUE);
            MAX_DISTANCE = b.translation("zombietactics2.midnightconfig.max_mine_dist").defineInRange("maxDistForMining", Config.maxDist, 0.0, Double.MAX_VALUE);
            MAX_HARDNESS = b.translation("zombietactics2.midnightconfig.max_hardness").defineInRange("maxHardness", Config.maxHardness, 0.0, Double.MAX_VALUE);
            DROP_BROKEN_BLOCKS = b.translation("zombietactics2.midnightconfig.drop_blocks").define("dropBrokenBlocks", Config.dropBlocks);
            HARDNESS_MULTIPLIER = b.translation("zombietactics2.midnightconfig.hardness_multiplier").defineInRange("hardnessMultiplier", Config.hardnessMultiplier, 0.0, Double.MAX_VALUE);
            STRICT_MINE = b.translation("zombietactics2.midnightconfig.strict_mine").define("strictMine", Config.strictMine);
            BREAK_CHEST = b.translation("zombietactics2.midnightconfig.break_chest").define("breakChest", Config.breakChest);
            FIND_CHEST_RANGE = b.translation("zombietactics2.midnightconfig.find_chest_range").defineInRange("findChestRange", Config.findChest, 1, 256);
            b.pop();
            b.push("Climbing");
            ZOMBIE_CLIMBING = b.translation("zombietactics2.midnightconfig.do_climb").define("zombiesClimb", Config.zombiesClimbing);
            CLIMBING_SPEED = b.translation("zombietactics2.midnightconfig.climb_speed").defineInRange("zombieClimbingSpeed", Config.climbingSpeed, 0.0, Double.MAX_VALUE);
            CLIMB_LIMIT_TICKS = b.comment("Zombie climbing limit ticks").translation("zombietactics2.midnightconfig.climb_limit_ticks").defineInRange("climbLimitTicks", Config.climbLimitTicks, 1, Integer.MAX_VALUE);
            HYPER_CLIMBING = b.translation("zombietactics2.midnightconfig.hyper_climbing").define("hyperClimbing", Config.hyperClimbing);
            RANDOM_CLIMB = b.translation("zombietactics2.midnightconfig.randomly_climb").define("randomlyClimb", Config.randomlyClimb);
            b.pop();
            b.push("Spawn");
            PERSISTENCE_CHANCE = b.translation("zombietactics2.midnightconfig.persistence_chance").defineInRange("persistenceChance", Config.persistenceChance, 0.0, 1.0);
            MAX_THRESHOLD = b.translation("zombietactics2.midnightconfig.max_threshold").defineInRange("maxThreshold", Config.maxThreshold, 0, Integer.MAX_VALUE);
            SPAWN_UNDER_SUN = b.translation("zombietactics2.midnightconfig.spawn_under_sun").define("spawnUnderSun", Config.spawnUnderSun);
            NO_DESPAWN = b.translation("zombietactics2.midnightconfig.no_despawn").define("noDespawn", Config.noDespawn);
            b.pop();
            b.push("Targeting");
            TARGET_ANIMALS = b.translation("zombietactics2.midnightconfig.do_hurt_animals").define("zombiesTargetAnimals", Config.targetAnimals);
            BLOCK_COST = b.translation("zombietactics2.midnightconfig.block_cost").defineInRange("blockCost", Config.blockCost, 1, 65536);
            FOLLOW_RANGE = b.translation("zombietactics2.midnightconfig.follow_range").defineInRange("followRange", Config.followRange, 1, 128);
            TARGET_TYPE = b.translation("zombietactics2.midnightconfig.find_target_type").defineEnum("findTargetType", (Enum)Config.findTargetType);
            ATTACK_RANGE = b.translation("zombietactics2.midnightconfig.attack_range").defineInRange("", Config.attackRange, 0.25, 127.0);
            ATTACK_INVISIBLE = b.translation("zombietactics2.midnightconfig.attack_invisible").define("targetVisibilityCheck", Config.attackInvisible);
            b.pop();
            b.push("Optimize");
            PATH_ACCURACY = b.translation("zombietactics2.midnightconfig.accuracy").defineInRange("pathAccuracy", Config.accuracy, 0, 95);
            NO_IDLE = b.translation("zombietactics2.midnightconfig.no_idle").define("noIdle", Config.noIdle);
            b.pop();
            b.push("Flying");
            CAN_FLY = b.translation("zombietactics2.midnightconfig.can_fly").define("canFly", Config.canFly);
            FLY_SPEED = b.translation("zombietactics2.midnightconfig.fly_speed").defineInRange("flySpeed", Config.flySpeed, 0.0, 32.0);
            b.pop();
            b.push("General");
            HEAL_AMOUNT = b.translation("zombietactics2.midnightconfig.heal_amount").defineInRange("healAmount", Config.healAmount, 0.0, 1024.0);
            ATTACK_COOLDOWN = b.translation("zombietactics2.midnightconfig.attack_cooldown").defineInRange("attackCooldown", Config.attackCooldown, 1, 1000);
            AGGRESSIVE_SPEED = b.translation("zombietactics2.midnightconfig.aggressive_speed").defineInRange("aggressiveSpeed", Config.aggressiveSpeed, 0.01, 128.0);
            SUN_SENSITIVE = b.translation("zombietactics2.midnightconfig.sun_sensitive").define("sunSensitive", Config.sunSensitive);
            NO_MERCY = b.translation("zombietactics2.midnightconfig.no_mercy").define("noMercy", Config.noMercy);
            CAN_FLOAT = b.translation("zombietactics2.midnightconfig.can_float").define("canFloat", Config.canFloat);
            JUMP_ACCELERATION = b.translation("zombietactics2.midnightconfig.jump_acceleration").defineInRange("jumpAcceleration", Config.jumpAcceleration, 0.0, 128.0);
            JUMP_BLOCK = b.translation("zombietactics2.midnightconfig.jump_block").define("jumpBlock", Config.jumpBlock);
            PICKUP_RANGE = b.translation("zombietactics2.midnightconfig.pickup_range").defineInRange("pickupRange", Config.pickupRange, 0, 128);
            b.pop();
            b.push("Debug");
            SHOW_NODES = b.define("showNodes", Config.showNodes);
            SHOW_DELTA_MOVEMENT = b.define("showDeltaMovement", Config.showDeltaMovement);
            b.pop();
        }
    }
}

