/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.goals.mining;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.attachments.MiningRoutines;
import net.picopress.mc.mods.zombietactics2.goals.BreakBlockGoal;
import net.picopress.mc.mods.zombietactics2.util.Tactics;
import org.jetbrains.annotations.NotNull;

public class MonsterBreakBlockGoal<T extends Monster>
extends BreakBlockGoal {
    private final T zombie;

    public MonsterBreakBlockGoal(T zombie) {
        super((Mob)zombie, Config.hardnessMultiplier, Config.break_speed, Config.dropBlocks);
        this.zombie = zombie;
    }

    protected BlockPos[] getCandidate(@NotNull LivingEntity liv) {
        double deltaY = liv.getY() - this.zombie.getY();
        if (deltaY > -2.0 && deltaY < 2.0) {
            return MiningRoutines.routineFlat;
        }
        if (deltaY <= -2.0) {
            return MiningRoutines.routineDown;
        }
        return MiningRoutines.routineUp;
    }

    @Override
    protected boolean checkBlock(BlockPos pos) {
        boolean ret;
        float destroying = this.level.getBlockState(pos).getBlock().defaultDestroyTime();
        boolean bl = ret = super.checkBlock(pos) && (double)destroying <= Config.maxHardness;
        if (ret) {
            this.mine.bp = pos;
            this.mine.bp_vec3 = pos.getCenter();
            this.mine.doMining = true;
        }
        return ret;
    }

    @Override
    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.zombie.distanceToSqr(this.mine.bp_vec3) <= Config.maxDist * Config.maxDist;
    }

    @Override
    public void tick() {
        double dist = this.zombie.distanceToSqr(this.mine.bp_vec3);
        if (dist <= Config.minDist || dist > Config.maxDist) {
            this.mine.doMining = false;
            return;
        }
        super.tick();
    }

    @Override
    public boolean canUse() {
        block8: {
            block9: {
                if (!super.canUse()) {
                    return false;
                }
                double len = this.zombie.getDeltaMovement().length();
                if ((len > 0.8 || Config.strictMine && len > 0.1) && !Config.canFly) {
                    return false;
                }
                LivingEntity liv = this.zombie.getTarget();
                PathNavigation nav = this.zombie.getNavigation();
                if (!nav.isDone() || liv == null || nav.getPath() == null || nav.getPath().canReach()) break block9;
                if (this.zombie.isWithinMeleeAttackRange(liv) && this.zombie.hasLineOfSight((Entity)liv)) {
                    return false;
                }
                if (nav.moveTo((Entity)liv, (double)this.zombie.getSpeed())) {
                    return false;
                }
                BlockPos[] set = this.getCandidate(liv);
                int airStack = 0;
                for (BlockPos pos : set) {
                    BlockPos temp = this.zombie.blockPosition().offset((Vec3i)pos.rotate(Tactics.getRelativeRotation(this.zombie)));
                    if (this.level.getBlockState(temp).isAir()) {
                        ++airStack;
                    }
                    if (airStack != set.length - 1) {
                        if (!this.checkBlock(temp)) continue;
                        return true;
                    }
                    break block8;
                }
                break block8;
            }
            if (!this.zombie.isInWall()) break block8;
            for (BlockPos p : MiningRoutines.routineWall) {
                BlockPos temp = this.zombie.blockPosition().offset((Vec3i)p);
                if (!this.checkBlock(temp)) continue;
                return true;
            }
        }
        return false;
    }
}

