/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.goals.move;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.picopress.mc.mods.zombietactics2.impl.Plane;
import org.jetbrains.annotations.NotNull;

public class SelectiveFloatGoal
extends FloatGoal {
    private final Mob mob;
    private final Plane plane;
    private boolean needBreathe = false;

    public SelectiveFloatGoal(Mob mob) {
        super(mob);
        this.mob = mob;
        this.plane = (Plane)mob;
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return super.canUse();
        }
        if (this.plane.zombie_tactics$getInt(0) > this.calculateBreath(target)) {
            this.needBreathe = true;
        }
        return super.canUse() && (!target.isInWater() || this.mob.getBlockY() - target.getBlockY() < 1 || this.needBreathe);
    }

    public boolean canContinueToUse() {
        if (this.plane.zombie_tactics$getInt(0) < 20) {
            this.needBreathe = false;
        }
        return super.canUse() || this.needBreathe;
    }

    private int calculateBreath(@NotNull LivingEntity target) {
        return 600 - (this.mob.getBlockY() - target.getBlockY()) * 50;
    }
}

