/*
 * Decompiled with CFR 0.152.
 */
package net.picopress.mc.mods.zombietactics2.goals.move;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.picopress.mc.mods.zombietactics2.Config;
import net.picopress.mc.mods.zombietactics2.impl.Plane;
import net.picopress.mc.mods.zombietactics2.util.Tactics;

public class ZombieGoal
extends ZombieAttackGoal {
    private Vec3 delta;
    private boolean jumping = false;
    Zombie mob;

    public ZombieGoal(Zombie zombie, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super(zombie, speedModifier, followingTargetEvenIfNotSeen);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.mob = zombie;
    }

    protected int getAttackInterval() {
        return this.adjustedTickDelay(Config.attackCooldown);
    }

    public void tick() {
        Optional bp;
        ServerLevel server;
        Path path;
        super.tick();
        if (Config.showNodes && (path = this.mob.getNavigation().getPath()) != null && this.mob.getServer() != null && (server = this.mob.getServer().getLevel(this.mob.level().dimension())) != null) {
            for (int i = 0; i < path.getNodeCount(); ++i) {
                BlockPos pos = path.getNode(i).asBlockPos();
                server.sendParticles((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0, 0.0, 0.0, 0.1, 0.1);
            }
        }
        if (this.mob.onGround()) {
            this.jumping = false;
        }
        if (this.jumping && ((Plane)this.mob).zombie_tactics$getInt(1) == 0) {
            this.mob.setDeltaMovement(this.delta.x, this.mob.getDeltaMovement().y, this.delta.z);
        }
        if (Config.jumpBlock && !this.mob.isWithinMeleeAttackRange(this.mob.getTarget()) && this.mob.getNavigation().isDone() && (bp = this.mob.mainSupportingBlockPos).isPresent()) {
            BlockPos pos = ((BlockPos)bp.get()).mutable().offset((Vec3i)Tactics.UNIT_FRONT.rotate(Tactics.getRelativeRotation((Mob)this.mob))).above().above();
            boolean airs = true;
            for (int i = 0; i < 5; ++i) {
                if (!this.mob.level().isEmptyBlock(pos) && !this.mob.level().getBlockState(pos).is(Blocks.LAVA)) {
                    airs = false;
                    break;
                }
                if (this.mob.level().getBlockState(pos).is(Blocks.LAVA)) break;
                if (i == 4) continue;
                pos = pos.below();
            }
            if (airs) {
                this.jumping = true;
                this.mob.getJumpControl().jump();
                this.delta = Objects.requireNonNull(this.mob.getTarget()).position().subtract(this.mob.position());
                this.delta = this.delta.scale(Config.jumpAcceleration / this.delta.length());
                this.mob.addDeltaMovement(this.delta);
            }
        }
    }
}

